/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j;

import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import mousio.client.retry.RetryPolicy;
import mousio.client.retry.RetryWithExponentialBackOff;
import mousio.etcd4j.EtcdSecurityContext;
import mousio.etcd4j.requests.EtcdKeyDeleteRequest;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.requests.EtcdKeyPostRequest;
import mousio.etcd4j.requests.EtcdKeyPutRequest;
import mousio.etcd4j.requests.EtcdLeaderStatsRequest;
import mousio.etcd4j.requests.EtcdOldVersionRequest;
import mousio.etcd4j.requests.EtcdSelfStatsRequest;
import mousio.etcd4j.requests.EtcdStoreStatsRequest;
import mousio.etcd4j.requests.EtcdVersionRequest;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdLeaderStatsResponse;
import mousio.etcd4j.responses.EtcdSelfStatsResponse;
import mousio.etcd4j.responses.EtcdStoreStatsResponse;
import mousio.etcd4j.responses.EtcdVersionResponse;
import mousio.etcd4j.transport.EtcdClientImpl;
import mousio.etcd4j.transport.EtcdNettyClient;

public class EtcdClient
implements Closeable {
    private final EtcdClientImpl client;
    private RetryPolicy retryHandler;

    public EtcdClient(URI ... baseUri) {
        this(EtcdSecurityContext.NONE, baseUri);
    }

    public EtcdClient(String username, String password, URI ... baseUri) {
        this(EtcdSecurityContext.withCredential(username, password), baseUri);
    }

    public EtcdClient(SslContext sslContext, String username, String password, URI ... baseUri) {
        this(new EtcdSecurityContext(sslContext, username, password), baseUri);
    }

    public EtcdClient(SslContext sslContext, URI ... baseUri) {
        this(EtcdSecurityContext.withSslContext(sslContext), baseUri);
    }

    public EtcdClient(EtcdSecurityContext securityContext, URI ... baseUri) {
        URI[] uRIArray;
        if (baseUri.length == 0) {
            URI[] uRIArray2 = new URI[1];
            uRIArray = uRIArray2;
            uRIArray2[0] = URI.create("https://127.0.0.1:4001");
        } else {
            uRIArray = baseUri;
        }
        this(new EtcdNettyClient(securityContext, uRIArray));
    }

    public EtcdClient(EtcdClientImpl etcdClientImpl) {
        this.client = etcdClientImpl;
        this.retryHandler = RetryWithExponentialBackOff.DEFAULT;
    }

    @Deprecated
    public String getVersion() {
        try {
            return (String)new EtcdOldVersionRequest(this.client, this.retryHandler).send().get();
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException e) {
            return null;
        }
    }

    public EtcdVersionResponse version() {
        try {
            return (EtcdVersionResponse)new EtcdVersionRequest(this.client, this.retryHandler).send().get();
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException e) {
            return null;
        }
    }

    public EtcdSelfStatsResponse getSelfStats() {
        try {
            return (EtcdSelfStatsResponse)new EtcdSelfStatsRequest(this.client, this.retryHandler).send().get();
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException e) {
            return null;
        }
    }

    public EtcdLeaderStatsResponse getLeaderStats() {
        try {
            return (EtcdLeaderStatsResponse)new EtcdLeaderStatsRequest(this.client, this.retryHandler).send().get();
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException e) {
            return null;
        }
    }

    public EtcdStoreStatsResponse getStoreStats() {
        try {
            return (EtcdStoreStatsResponse)new EtcdStoreStatsRequest(this.client, this.retryHandler).send().get();
        }
        catch (IOException | TimeoutException | EtcdAuthenticationException | EtcdException e) {
            return null;
        }
    }

    public EtcdKeyPutRequest put(String key, String value) {
        return new EtcdKeyPutRequest(this.client, key, this.retryHandler).value(value);
    }

    public EtcdKeyPutRequest refresh(String key, Integer ttl) {
        return new EtcdKeyPutRequest(this.client, key, this.retryHandler).refresh(ttl);
    }

    public EtcdKeyPutRequest putDir(String dir) {
        return new EtcdKeyPutRequest(this.client, dir, this.retryHandler).isDir();
    }

    public EtcdKeyPostRequest post(String key, String value) {
        return new EtcdKeyPostRequest(this.client, key, this.retryHandler).value(value);
    }

    public EtcdKeyDeleteRequest delete(String key) {
        return new EtcdKeyDeleteRequest(this.client, key, this.retryHandler);
    }

    public EtcdKeyDeleteRequest deleteDir(String dir) {
        return new EtcdKeyDeleteRequest(this.client, dir, this.retryHandler).dir();
    }

    public EtcdKeyGetRequest get(String key) {
        return new EtcdKeyGetRequest(this.client, key, this.retryHandler);
    }

    public EtcdKeyGetRequest getDir(String dir) {
        return new EtcdKeyGetRequest(this.client, dir, this.retryHandler).dir();
    }

    public EtcdKeyGetRequest getAll() {
        return new EtcdKeyGetRequest(this.client, this.retryHandler);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    public EtcdClient setRetryHandler(RetryPolicy retryHandler) {
        this.retryHandler = retryHandler;
        return this;
    }
}

