/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.DataInput;
import java.io.IOException;
import java.nio.charset.Charset;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdHeaderAwareResponse;
import mousio.etcd4j.responses.EtcdResponseDecoder;

public class EtcdResponseDecoders {
    protected static final CharSequence X_ETCD_CLUSTER_ID = "X-Etcd-Cluster-Id";
    protected static final CharSequence X_ETCD_INDEX = "X-Etcd-Index";
    protected static final CharSequence X_RAFT_INDEX = "X-Raft-Index";
    protected static final CharSequence X_RAFT_TERM = "X-Raft-Term";
    public static final EtcdResponseDecoder<String> STRING_DECODER = new StringDecoder();
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(new Module[]{new AfterburnerModule()});

    public static <T> EtcdResponseDecoder<T> json(Class<T> type) {
        return new JsonDecoder<T>(type);
    }

    public static EtcdResponseDecoder<String> string() {
        return new StringDecoder();
    }

    public static abstract class StringToObjectDecoder<T>
    implements EtcdResponseDecoder<T> {
        @Override
        public T decode(HttpHeaders headers, ByteBuf content) throws EtcdException, IOException {
            return this.newInstance(content.toString(Charset.defaultCharset()));
        }

        protected abstract T newInstance(String var1);
    }

    public static class StringDecoder
    implements EtcdResponseDecoder<String> {
        @Override
        public String decode(HttpHeaders headers, ByteBuf content) throws EtcdException, IOException {
            return content.toString(Charset.defaultCharset());
        }
    }

    public static class JsonDecoder<T>
    implements EtcdResponseDecoder<T> {
        private final Class<T> type;

        public JsonDecoder(Class<T> type) {
            this.type = type;
        }

        @Override
        public T decode(HttpHeaders headers, ByteBuf content) throws EtcdException, IOException {
            ByteBufInputStream di = new ByteBufInputStream(content);
            Object value = MAPPER.readValue((DataInput)di, this.type);
            if (headers != null && EtcdHeaderAwareResponse.class.isAssignableFrom(this.type)) {
                ((EtcdHeaderAwareResponse)value).loadHeaders(headers);
            }
            return (T)value;
        }
    }
}

