/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.requests;

import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.requests.AbstractEtcdRequest;
import mousio.etcd4j.responses.EtcdKeysResponse;
import mousio.etcd4j.transport.EtcdClientImpl;

public class EtcdKeyRequest
extends AbstractEtcdRequest<EtcdKeysResponse> {
    protected final String key;
    protected final Map<String, String> requestParams;

    public EtcdKeyRequest(EtcdClientImpl clientImpl, HttpMethod method, RetryPolicy retryHandler) {
        this(clientImpl, method, retryHandler, (String)null);
    }

    public EtcdKeyRequest(EtcdClientImpl clientImpl, HttpMethod method, RetryPolicy retryHandler, String key) {
        super(null, clientImpl, method, retryHandler, EtcdKeysResponse.DECODER);
        if (key != null && key.startsWith("/")) {
            key = key.substring(1);
        }
        this.key = key;
        this.requestParams = new HashMap<String, String>();
    }

    @Override
    public EtcdResponsePromise<EtcdKeysResponse> send() throws IOException {
        return this.clientImpl.send(this);
    }

    @Override
    public String getUri() {
        if (this.key != null) {
            return "/v2/keys/" + this.key;
        }
        return "/v2/keys/";
    }

    @Override
    public Map<String, String> getRequestParams() {
        return this.requestParams;
    }

    @Override
    public boolean hasRequestParams() {
        return !this.requestParams.isEmpty();
    }
}

