/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.github.wnameless.json.flattener.KeyTransformer;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.DatatypeConverter;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.requests.EtcdKeyGetRequest;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Long getHeaderPropertyAsLong(HttpHeaders headers, String key) {
        String headerValue = headers.get(key);
        if (headerValue != null) {
            try {
                return Long.parseLong(headerValue);
            }
            catch (Exception e) {
                LOGGER.warn("could not parse " + key + " header", (Throwable)e);
            }
        }
        return null;
    }

    public static String jsonToString(JsonNode jsonNode) {
        try {
            Object json = mapper.readValue(jsonNode.toString(), Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json);
        }
        catch (Exception e) {
            LOGGER.error("unable to print json", (Throwable)e);
            return null;
        }
    }

    public static JsonNode stringToJson(String json) throws IOException {
        return mapper.readTree(json);
    }

    public static Date convertDate(String date) {
        return DatatypeConverter.parseDateTime((String)date).getTime();
    }

    public static JsonNode getAsJson(String path, EtcdClient etcdClient) throws IOException, EtcdAuthenticationException, TimeoutException, EtcdException {
        EtcdKeyGetRequest etcdKeyGetRequest = etcdClient.get(path).recursive();
        EtcdKeysResponse dataTree = etcdKeyGetRequest.send().get();
        ObjectNode jNode = JsonNodeFactory.instance.objectNode();
        if (dataTree.getNode().getNodes().isEmpty()) {
            EtcdUtil.iterateOverNodes(jNode, dataTree.getNode());
        } else {
            for (EtcdKeysResponse.EtcdNode node : dataTree.getNode().getNodes()) {
                EtcdUtil.iterateOverNodes(jNode, node);
            }
        }
        return EtcdUtil.dotNotationToStandardJson(jNode.at(path));
    }

    public static void putAsJson(String path, JsonNode data, EtcdClient etcdClient) throws IOException, EtcdAuthenticationException, TimeoutException, EtcdException {
        Map flattened;
        block3: {
            flattened = new JsonFlattener(EtcdUtil.jsonToString(data)).withFlattenMode(FlattenMode.MONGODB).withSeparator('/').flattenAsMap();
            try {
                etcdClient.delete(path).recursive().send().get();
            }
            catch (EtcdException e) {
                if (100 == e.errorCode) break block3;
                throw e;
            }
        }
        for (Map.Entry entry : flattened.entrySet()) {
            etcdClient.put(path + "/" + (String)entry.getKey(), String.valueOf(entry.getValue())).send().get();
        }
    }

    private static JsonNode dotNotationToStandardJson(JsonNode etcdJson) throws IOException {
        if (!etcdJson.isValueNode()) {
            String unflattened = new JsonUnflattener(EtcdUtil.jsonToString((JsonNode)EtcdUtil.flattenJson(etcdJson, ""))).withFlattenMode(FlattenMode.MONGODB).withKeyTransformer(new KeyTransformer(){

                public String transform(String s) {
                    return s.replaceAll("__DOT__", "\\.");
                }
            }).unflatten();
            return mapper.readTree(unflattened);
        }
        return etcdJson;
    }

    private static void iterateOverNodes(ObjectNode json, EtcdKeysResponse.EtcdNode node) {
        if (node.isDir()) {
            for (EtcdKeysResponse.EtcdNode n : node.getNodes()) {
                EtcdUtil.iterateOverNodes(json, n);
            }
        } else {
            ArrayList<String> keyPath = new ArrayList<String>();
            for (String key : node.getKey().split("/")) {
                if (key.isEmpty()) continue;
                keyPath.add(key);
            }
            ObjectNode jsonNodes = json;
            Iterator iterator = keyPath.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (jsonNodes.get(key = key.replaceAll("\\.", "__DOT__")) == null) {
                    if (iterator.hasNext()) {
                        jsonNodes = jsonNodes.putObject(key);
                        continue;
                    }
                    jsonNodes = jsonNodes.put(key, node.getValue());
                    continue;
                }
                jsonNodes = (ObjectNode)jsonNodes.get(key);
            }
        }
    }

    private static ObjectNode flattenJson(JsonNode node, String currentPath) {
        ObjectNode transformed = JsonNodeFactory.instance.objectNode();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            if (((JsonNode)next.getValue()).isValueNode()) {
                String path = currentPath + "." + (String)next.getKey();
                String strValue = ((JsonNode)next.getValue()).asText();
                if (NumberUtils.isCreatable((String)strValue)) {
                    Class numberType = EtcdUtil.numberType(strValue);
                    if (numberType.isAssignableFrom(Integer.class)) {
                        transformed.put(path.substring(1), Integer.valueOf(strValue));
                        continue;
                    }
                    if (numberType.isAssignableFrom(Long.class)) {
                        transformed.put(path.substring(1), Long.valueOf(strValue));
                        continue;
                    }
                    if (numberType.isAssignableFrom(Float.class)) {
                        transformed.put(path.substring(1), Float.valueOf(strValue));
                        continue;
                    }
                    if (!numberType.isAssignableFrom(Double.class)) continue;
                    transformed.put(path.substring(1), Double.valueOf(strValue));
                    continue;
                }
                if (EtcdUtil.booleanType(strValue)) {
                    transformed.put(path.substring(1), Boolean.valueOf(strValue));
                    continue;
                }
                if (EtcdUtil.arrayType(strValue)) {
                    transformed.putArray(path.substring(1));
                    continue;
                }
                transformed.set(path.substring(1), (JsonNode)next.getValue());
                continue;
            }
            transformed.setAll(EtcdUtil.flattenJson((JsonNode)next.getValue(), currentPath + "." + (String)next.getKey()));
        }
        return transformed;
    }

    private static Class numberType(String value) throws NumberFormatException {
        try {
            Integer.valueOf(value);
            return Integer.class;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Long.valueOf(value);
                return Long.class;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    Float.valueOf(value);
                    return Float.class;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        Double.valueOf(value);
                        return Double.class;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        throw new NumberFormatException();
                    }
                }
            }
        }
    }

    private static boolean booleanType(String value) {
        return "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
    }

    private static boolean arrayType(String value) {
        return "[]".equalsIgnoreCase(value);
    }

    static {
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }
}

