/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.CancellationException;
import mousio.client.ConnectionState;
import mousio.client.retry.RetryHandler;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.requests.EtcdKeyRequest;
import mousio.etcd4j.requests.EtcdRequest;
import mousio.etcd4j.requests.EtcdVersionRequest;
import mousio.etcd4j.transport.AbstractEtcdResponseHandler;
import mousio.etcd4j.transport.EtcdClientImpl;
import mousio.etcd4j.transport.EtcdKeyResponseHandler;
import mousio.etcd4j.transport.EtcdNettyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdNettyClient
implements EtcdClientImpl {
    private static final Logger logger = LoggerFactory.getLogger(EtcdNettyClient.class);
    private final EventLoopGroup eventLoopGroup;
    private final URI[] uris;
    private final Bootstrap bootstrap;
    protected int lastWorkingUriIndex = 0;

    public EtcdNettyClient(SslContext sslContext, URI ... uri) {
        this(new EtcdNettyConfig(), sslContext, uri);
    }

    public EtcdNettyClient(final EtcdNettyConfig config, final SslContext sslContext, URI ... uris) {
        logger.info("Setting up Etcd4j Netty client");
        this.uris = uris;
        this.eventLoopGroup = config.getEventLoopGroup();
        this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(config.getSocketChannelClass())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)config.getConnectTimeout())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                if (sslContext != null) {
                    p.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc())});
                }
                p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                p.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                p.addLast("aggregate", (ChannelHandler)new HttpObjectAggregator(config.getMaxFrameSize()));
            }
        });
    }

    protected Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public <R> EtcdResponsePromise<R> send(final EtcdRequest<R> etcdRequest) throws IOException {
        final ConnectionState connectionState = new ConnectionState(this.uris);
        connectionState.uriIndex = this.lastWorkingUriIndex;
        if (etcdRequest.getPromise() == null) {
            EtcdResponsePromise responsePromise = new EtcdResponsePromise(etcdRequest.getRetryPolicy(), connectionState, new RetryHandler(){

                @Override
                public void doRetry() throws IOException {
                    EtcdNettyClient.this.connect(etcdRequest, connectionState);
                }
            });
            etcdRequest.setPromise(responsePromise);
        }
        connectionState.startTime = new Date().getTime();
        this.connect(etcdRequest, connectionState);
        return etcdRequest.getPromise();
    }

    protected <R> void connect(EtcdRequest<R> etcdRequest) throws IOException {
        this.connect(etcdRequest, etcdRequest.getPromise().getConnectionState());
    }

    protected <R> void connect(final EtcdRequest<R> etcdRequest, final ConnectionState connectionState) throws IOException {
        URI uri = this.uris[connectionState.uriIndex];
        URI requestUri = URI.create(etcdRequest.getUrl());
        if (requestUri.getHost() != null && requestUri.getPort() > -1) {
            uri = requestUri;
        }
        ChannelFuture connectFuture = this.bootstrap.clone().connect(uri.getHost(), uri.getPort());
        final Channel channel = connectFuture.channel();
        etcdRequest.getPromise().attachNettyPromise((Promise<R>)new DefaultPromise((EventExecutor)connectFuture.channel().eventLoop()));
        connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(final ChannelFuture f) throws Exception {
                if (!f.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Connection failed to " + connectionState.uris[connectionState.uriIndex]);
                    }
                    etcdRequest.getPromise().handleRetry(f.cause());
                    return;
                }
                if (etcdRequest.getPromise().getNettyPromise().isCancelled()) {
                    f.channel().close();
                    etcdRequest.getPromise().getNettyPromise().setFailure((Throwable)new CancellationException());
                    return;
                }
                final Promise listenedToPromise = etcdRequest.getPromise().getNettyPromise();
                listenedToPromise.addListener(new GenericFutureListener<Future<?>>(){

                    public void operationComplete(Future<?> future) throws Exception {
                        if (etcdRequest.getPromise().getNettyPromise() == listenedToPromise) {
                            f.channel().close();
                        }
                    }
                });
                if (logger.isDebugEnabled()) {
                    logger.debug("Connected to " + channel.remoteAddress().toString());
                }
                EtcdNettyClient.this.lastWorkingUriIndex = connectionState.uriIndex;
                EtcdNettyClient.this.modifyPipeLine(etcdRequest, f.channel().pipeline());
                EtcdNettyClient.this.createAndSendHttpRequest(etcdRequest.getUrl(), etcdRequest, channel).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            etcdRequest.getPromise().setException(future.cause());
                            f.channel().close();
                        }
                    }
                });
                channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Connection closed for request " + etcdRequest.getMethod().name() + " " + etcdRequest.getUri());
                        }
                    }
                });
            }
        });
    }

    private <R> void modifyPipeLine(final EtcdRequest<R> req, ChannelPipeline pipeline) {
        AbstractEtcdResponseHandler handler;
        if (req.getTimeout() != -1L) {
            pipeline.addFirst(new ChannelHandler[]{new ReadTimeoutHandler(req.getTimeout(), req.getTimeoutUnit())});
        }
        if (req instanceof EtcdKeyRequest) {
            handler = new EtcdKeyResponseHandler(this, (EtcdKeyRequest)req);
        } else if (req instanceof EtcdVersionRequest) {
            handler = new AbstractEtcdResponseHandler<EtcdVersionRequest, FullHttpResponse>(this, (EtcdVersionRequest)req){

                protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                    ((EtcdVersionRequest)req).getPromise().getNettyPromise().setSuccess((Object)msg.content().toString(Charset.defaultCharset()));
                }
            };
        } else {
            throw new RuntimeException("Unknown request type " + req.getClass().getName());
        }
        pipeline.addLast(new ChannelHandler[]{handler});
        pipeline.addLast(new ChannelHandler[]{new ChannelHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                handler.retried(true);
                req.getPromise().handleRetry(cause);
            }
        }});
    }

    private <R> ChannelFuture createAndSendHttpRequest(String uri, EtcdRequest<R> etcdRequest, Channel channel) throws Exception {
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, etcdRequest.getMethod(), uri);
        httpRequest.headers().add("Connection", (Object)"keep-alive");
        httpRequest.headers().add("Host", (Object)InetAddress.getLocalHost().getHostName());
        HttpPostRequestEncoder bodyRequestEncoder = null;
        Map<String, String> keyValuePairs = etcdRequest.getRequestParams();
        if (keyValuePairs != null && !keyValuePairs.isEmpty()) {
            HttpMethod etcdRequestMethod = etcdRequest.getMethod();
            if (etcdRequestMethod == HttpMethod.POST || etcdRequestMethod == HttpMethod.PUT) {
                bodyRequestEncoder = new HttpPostRequestEncoder((HttpRequest)httpRequest, false);
                for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                    bodyRequestEncoder.addBodyAttribute(entry.getKey(), entry.getValue());
                }
                httpRequest = bodyRequestEncoder.finalizeRequest();
            } else {
                String getLocation = "";
                for (Map.Entry<String, String> entry : keyValuePairs.entrySet()) {
                    if (!getLocation.isEmpty()) {
                        getLocation = getLocation + "&";
                    }
                    getLocation = getLocation + entry.getKey() + "=" + entry.getValue();
                }
                if (!uri.contains("?")) {
                    httpRequest.setUri(uri.concat("?").concat(getLocation));
                } else {
                    httpRequest.setUri(uri);
                }
            }
        }
        etcdRequest.setHttpRequest((HttpRequest)httpRequest);
        ChannelFuture future = channel.write((Object)httpRequest);
        if (bodyRequestEncoder != null && bodyRequestEncoder.isChunked()) {
            future = channel.write((Object)bodyRequestEncoder);
        }
        channel.flush();
        return future;
    }

    @Override
    public void close() {
        logger.info("Shutting down Etcd4j Netty client");
        this.eventLoopGroup.shutdownGracefully();
    }
}

