/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;

public class EtcdKeysResponseParser {
    private static final JsonFactory factory = new JsonFactory();
    protected static final String X_ETCD_CLUSTER_ID = "X-Etcd-Cluster-Id";
    protected static final String X_ETCD_INDEX = "X-Etcd-Index";
    protected static final String X_RAFT_INDEX = "X-Raft-Index";
    protected static final String X_RAFT_TERM = "X-Raft-Term";
    private static final String ACTION = "action";
    private static final String NODE = "node";
    private static final String PREVNODE = "prevNode";
    private static final String KEY = "key";
    private static final String DIR = "dir";
    private static final String CREATEDINDEX = "createdIndex";
    private static final String MODIFIEDINDEX = "modifiedIndex";
    private static final String VALUE = "value";
    private static final String EXPIRATION = "expiration";
    private static final String TTL = "ttl";
    private static final String NODES = "nodes";
    private static final String CAUSE = "cause";
    private static final String ERRORCODE = "errorCode";
    private static final String MESSAGE = "message";
    private static final String INDEX = "index";

    public static EtcdKeysResponse parse(HttpHeaders headers, ByteBuf content) throws EtcdException, IOException {
        JsonParser parser = factory.createParser((InputStream)new ByteBufInputStream(content));
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().contentEquals(ACTION)) {
                return EtcdKeysResponseParser.parseResponse(headers, parser);
            }
            throw EtcdKeysResponseParser.parseException(parser);
        }
        return null;
    }

    private static EtcdException parseException(JsonParser parser) throws IOException {
        String cause = null;
        String message = null;
        Integer errorCode = null;
        Long index = null;
        JsonToken token = parser.getCurrentToken();
        while (token != JsonToken.END_OBJECT && token != null) {
            switch (parser.getCurrentName()) {
                case "cause": {
                    cause = parser.nextTextValue();
                    break;
                }
                case "message": {
                    message = parser.nextTextValue();
                    break;
                }
                case "errorCode": {
                    errorCode = parser.nextIntValue(0);
                    break;
                }
                case "index": {
                    index = parser.nextLongValue(0L);
                    break;
                }
                default: {
                    throw new JsonParseException("Unknown field in exception " + parser.getCurrentName(), parser.getCurrentLocation());
                }
            }
            token = parser.nextToken();
        }
        return new EtcdException(errorCode, cause, message, index);
    }

    private static EtcdKeysResponse parseResponse(HttpHeaders headers, JsonParser parser) throws IOException {
        String action = parser.nextTextValue();
        parser.nextToken();
        if (!parser.getCurrentName().contentEquals(NODE)) {
            throw new JsonParseException("Expecting 'node' as second field", parser.getCurrentLocation());
        }
        parser.nextToken();
        EtcdKeysResponse.EtcdNode node = EtcdKeysResponseParser.parseNode(parser);
        JsonToken token = parser.nextToken();
        EtcdKeysResponse.EtcdNode prevNode = null;
        if (token == JsonToken.FIELD_NAME) {
            if (!parser.getCurrentName().contentEquals(PREVNODE)) {
                throw new JsonParseException("Expecting 'node' as second field", parser.getCurrentLocation());
            }
            parser.nextToken();
            prevNode = EtcdKeysResponseParser.parseNode(parser);
            token = parser.nextToken();
        }
        String etcdClusterId = null;
        Long etcdIndex = null;
        Long raftIndex = null;
        Long raftTerm = null;
        if (headers != null) {
            etcdClusterId = headers.get(X_ETCD_CLUSTER_ID);
            etcdIndex = EtcdKeysResponseParser.convertLong(headers.get(X_ETCD_INDEX));
            raftIndex = EtcdKeysResponseParser.convertLong(headers.get(X_RAFT_INDEX));
            raftTerm = EtcdKeysResponseParser.convertLong(headers.get(X_RAFT_TERM));
        }
        if (token == JsonToken.END_OBJECT) {
            return new EtcdKeysResponse(action, node, prevNode, etcdClusterId, etcdIndex, raftIndex, raftTerm);
        }
        throw new JsonParseException("Unexpected content after response " + token, parser.getCurrentLocation());
    }

    private static Long convertLong(String s) {
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static EtcdKeysResponse.EtcdNode parseNode(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("Expecting object at start of node description", parser.getCurrentLocation());
        }
        JsonToken token = parser.nextToken();
        String key = null;
        String value = null;
        String expiration = null;
        long createdIndex = 0L;
        long modifiedIndex = 0L;
        long ttl = 0L;
        boolean dir = false;
        List<EtcdKeysResponse.EtcdNode> nodes = null;
        while (token != JsonToken.END_OBJECT && token != null) {
            switch (parser.getCurrentName()) {
                case "key": {
                    key = parser.nextTextValue();
                    break;
                }
                case "createdIndex": {
                    createdIndex = parser.nextLongValue(0L);
                    break;
                }
                case "modifiedIndex": {
                    modifiedIndex = parser.nextLongValue(0L);
                    break;
                }
                case "value": {
                    value = parser.nextTextValue();
                    break;
                }
                case "dir": {
                    dir = parser.nextBooleanValue();
                    break;
                }
                case "expiration": {
                    expiration = parser.nextTextValue();
                    break;
                }
                case "ttl": {
                    ttl = parser.nextLongValue(0L);
                    break;
                }
                case "nodes": {
                    parser.nextToken();
                    nodes = EtcdKeysResponseParser.parseNodes(parser);
                    break;
                }
                default: {
                    throw new JsonParseException("Unknown field " + parser.getCurrentName(), parser.getCurrentLocation());
                }
            }
            token = parser.nextToken();
        }
        return new EtcdKeysResponse.EtcdNode(dir, key, value, createdIndex, modifiedIndex, expiration, ttl, nodes);
    }

    protected static Date convertDate(String date) {
        return DatatypeConverter.parseDateTime((String)date).getTime();
    }

    private static List<EtcdKeysResponse.EtcdNode> parseNodes(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new JsonParseException("Expecting an array of nodes", parser.getCurrentLocation());
        }
        ArrayList<EtcdKeysResponse.EtcdNode> nodes = new ArrayList<EtcdKeysResponse.EtcdNode>();
        JsonToken token = parser.nextToken();
        while (token != JsonToken.END_ARRAY && token != null) {
            nodes.add(EtcdKeysResponseParser.parseNode(parser));
            token = parser.nextToken();
        }
        return nodes;
    }
}

