/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import mousio.etcd4j.responses.AbstractJsonResponseDecoder;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdSelfStatsResponse;

public class EtcdSelfStatsResponseDecoder
extends AbstractJsonResponseDecoder<EtcdSelfStatsResponse> {
    public static final EtcdSelfStatsResponseDecoder INSTANCE = new EtcdSelfStatsResponseDecoder();
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String RECVAPPENDREQUESTCNT = "recvAppendRequestCnt";
    public static final String RECVBANDWIDTHRATE = "recvBandwidthRate";
    public static final String RECVPKGRATE = "recvPkgRate";
    public static final String SENDAPPENDREQUESTCNT = "sendAppendRequestCnt";
    public static final String STARTTIME = "startTime";
    public static final String STATE = "state";
    public static final String LEADERINFO = "leaderInfo";
    public static final String LEADERINFO_LEADER = "leader";
    public static final String LEADERINFO_STARTTIME = "startTime";
    public static final String LEADERINFO_UPTIME = "uptime";

    @Override
    protected EtcdSelfStatsResponse decodeJson(HttpHeaders headers, JsonParser parser) throws EtcdException, IOException {
        String id = null;
        String name = null;
        long recvAppendRequestCnt = 0L;
        double recvBandwidthRate = 0.0;
        double recvPkgRate = 0.0;
        long sendAppendRequestCnt = 0L;
        Date startTime = null;
        String state = null;
        EtcdSelfStatsResponse.LeaderInfo leaderInfo = null;
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            JsonToken token = parser.nextToken();
            while (token != JsonToken.END_OBJECT && token != null) {
                switch (parser.getCurrentName()) {
                    case "id": {
                        id = parser.nextTextValue();
                        break;
                    }
                    case "name": {
                        name = parser.nextTextValue();
                        break;
                    }
                    case "recvAppendRequestCnt": {
                        recvAppendRequestCnt = parser.nextLongValue(0L);
                        break;
                    }
                    case "recvBandwidthRate": {
                        recvBandwidthRate = Double.parseDouble(parser.nextTextValue());
                        break;
                    }
                    case "recvPkgRate": {
                        recvBandwidthRate = Double.parseDouble(parser.nextTextValue());
                        break;
                    }
                    case "sendAppendRequestCnt": {
                        sendAppendRequestCnt = parser.nextLongValue(0L);
                        break;
                    }
                    case "startTime": {
                        startTime = DatatypeConverter.parseDateTime((String)parser.nextTextValue()).getTime();
                        break;
                    }
                    case "state": {
                        state = parser.nextTextValue();
                        break;
                    }
                    case "leaderInfo": {
                        leaderInfo = EtcdSelfStatsResponseDecoder.parseLeaderInfo(parser, token);
                    }
                }
                token = parser.nextToken();
            }
            return new EtcdSelfStatsResponse(id, name, recvAppendRequestCnt, recvBandwidthRate, recvPkgRate, sendAppendRequestCnt, startTime, state, leaderInfo);
        }
        return null;
    }

    private static EtcdSelfStatsResponse.LeaderInfo parseLeaderInfo(JsonParser parser, JsonToken token) throws EtcdException, IOException {
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            String leader = null;
            Date startTime = null;
            String uptime = null;
            while (token != JsonToken.END_OBJECT && token != null) {
                switch (parser.getCurrentName()) {
                    case "leader": {
                        leader = parser.nextTextValue();
                        break;
                    }
                    case "startTime": {
                        startTime = DatatypeConverter.parseDateTime((String)parser.nextTextValue()).getTime();
                        break;
                    }
                    case "uptime": {
                        uptime = parser.nextTextValue();
                    }
                }
                token = parser.nextToken();
            }
            return new EtcdSelfStatsResponse.LeaderInfo(leader, startTime, uptime);
        }
        return null;
    }
}

