/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;
import mousio.etcd4j.responses.AbstractJsonResponseDecoder;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdVersionResponse;

public class EtcdVersionResponseDecoder
extends AbstractJsonResponseDecoder<EtcdVersionResponse> {
    public static final EtcdVersionResponseDecoder INSTANCE = new EtcdVersionResponseDecoder();
    private static final JsonFactory factory = new JsonFactory();
    private static final String ETCD_SERVER = "etcdserver";
    private static final String ETCD_CLUSTER = "etcdcluster";

    @Override
    public EtcdVersionResponse decodeJson(HttpHeaders headers, JsonParser parser) throws EtcdException, IOException {
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            if (parser.nextToken() != JsonToken.FIELD_NAME || !parser.getCurrentName().contentEquals(ETCD_SERVER)) {
                throw new JsonParseException("Expecting 'etcdserver' as first field", parser.getCurrentLocation());
            }
            String etcdserver = parser.nextTextValue();
            if (parser.nextToken() != JsonToken.FIELD_NAME || !parser.getCurrentName().contentEquals(ETCD_CLUSTER)) {
                throw new JsonParseException("Expecting 'etcdcluster' as second field", parser.getCurrentLocation());
            }
            String etcdcluster = parser.nextTextValue();
            return new EtcdVersionResponse(etcdserver, etcdcluster);
        }
        return null;
    }
}

