/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.transport;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import mousio.client.exceptions.PrematureDisconnectException;
import mousio.etcd4j.requests.EtcdRequest;
import mousio.etcd4j.responses.EtcdAuthenticationException;
import mousio.etcd4j.transport.EtcdNettyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EtcdResponseHandler<R>
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(EtcdResponseHandler.class);
    private static final CharSequence HTTP_HEADER_LOCATION = "Location";
    protected final Promise<R> promise;
    protected final EtcdNettyClient client;
    protected final EtcdRequest<R> request;
    private boolean isRetried;

    public EtcdResponseHandler(EtcdNettyClient etcdNettyClient, EtcdRequest<R> etcdRequest) {
        this.client = etcdNettyClient;
        this.request = etcdRequest;
        this.promise = etcdRequest.getPromise().getNettyPromise();
        this.isRetried = false;
    }

    public void retried(boolean retried) {
        this.isRetried = retried;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (!this.isRetried && !this.promise.isDone()) {
            this.request.getPromise().handleRetry(new PrematureDisconnectException());
        }
        super.channelUnregistered(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Received " + response.status().code() + " for " + this.request.getMethod().name() + " " + this.request.getUri());
        }
        if (response.status().equals((Object)HttpResponseStatus.MOVED_PERMANENTLY) || response.status().equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT)) {
            if (response.headers().contains(HTTP_HEADER_LOCATION)) {
                this.request.setUrl(response.headers().get(HTTP_HEADER_LOCATION));
                this.client.connect(this.request);
                ctx.close();
                if (logger.isDebugEnabled()) {
                    logger.debug("redirect for " + this.request.getHttpRequest().uri() + " to " + response.headers().get(HTTP_HEADER_LOCATION));
                }
            } else {
                this.promise.setFailure((Throwable)new Exception("Missing Location header on redirect"));
            }
        }
        if (response.status().equals((Object)HttpResponseStatus.UNAUTHORIZED)) {
            this.promise.setFailure((Throwable)new EtcdAuthenticationException(response.content().toString(CharsetUtil.UTF_8)));
        } else {
            if (!response.content().isReadable()) {
                if (response.status().equals((Object)HttpResponseStatus.OK) || response.status().equals((Object)HttpResponseStatus.ACCEPTED) || response.status().equals((Object)HttpResponseStatus.CREATED)) {
                    this.client.connect(this.request);
                    return;
                }
                this.promise.setFailure((Throwable)new IOException("Content was not readable. HTTP Status: " + response.status()));
            }
            try {
                this.promise.setSuccess(this.request.getResponseDecoder().decode(response.headers(), response.content()));
            }
            catch (Exception e) {
                this.promise.setFailure((Throwable)e);
            }
        }
    }
}

