/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.requests;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mousio.client.retry.RetryPolicy;
import mousio.etcd4j.promises.EtcdResponsePromise;
import mousio.etcd4j.responses.EtcdResponseDecoder;
import mousio.etcd4j.transport.EtcdClientImpl;

public abstract class EtcdRequest<R> {
    protected final EtcdClientImpl clientImpl;
    protected final HttpMethod method;
    protected RetryPolicy retryPolicy;
    private EtcdResponsePromise<R> promise;
    private final EtcdResponseDecoder<R> decoder;
    private long timeout = -1L;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private HttpRequest httpRequest;
    private String url;

    protected EtcdRequest(EtcdClientImpl clientImpl, HttpMethod method, RetryPolicy retryPolicy, EtcdResponseDecoder<R> decoder) {
        this.clientImpl = clientImpl;
        this.method = method;
        this.retryPolicy = retryPolicy;
        this.decoder = decoder;
    }

    public abstract EtcdResponsePromise<R> send() throws IOException;

    public EtcdResponseDecoder<R> getResponseDecoder() {
        return this.decoder;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public abstract String getUri();

    public Map<String, String> getRequestParams() {
        return null;
    }

    public void setPromise(EtcdResponsePromise<R> promise) {
        this.promise = promise;
    }

    public EtcdResponsePromise<R> getPromise() {
        return this.promise;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public EtcdRequest timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    public TimeUnit getTimeoutUnit() {
        return this.timeoutUnit;
    }

    public void setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public EtcdRequest setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        return this.getUri();
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

