/*
 * Decompiled with CFR 0.152.
 */
package org.movealong.bolt;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.jnape.palatable.lambda.adt.Try;
import com.jnape.palatable.lambda.functions.Effect;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.Alter;
import com.jnape.palatable.lambda.functions.specialized.Kleisli;
import com.jnape.palatable.lambda.io.IO;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class Bolt
implements RequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private static final Logger log = LoggerFactory.getLogger(Bolt.class);
    private final IO<APIGatewayProxyResponseEvent> handle;

    public Bolt() {
        Map<String, String> environment = System.getenv();
        String appName = environment.get("APP_NAME");
        String redisServer = environment.get("REDIS_SERVER");
        this.handle = (IO)Try.withResources(() -> new Jedis(redisServer), jedis -> Try.trying(() -> {
            jedis.connect();
            return jedis.get(appName + ":index:current-content");
        })).toEither().peek(ex -> IO.io(() -> log.error("Failed to serve request", ex)), __ -> IO.io(() -> log.info("Served current index"))).match(ex -> Bolt.responseEvent(500, ex.getMessage(), Collections.singletonMap("Content-Type", "text/plain")), idx -> Bolt.responseEvent(200, idx, Collections.singletonMap("Content-Type", "text/html")));
    }

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent request, Context context) {
        log.info("Getting index");
        return (APIGatewayProxyResponseEvent)this.handle.unsafePerformIO();
    }

    private static IO<APIGatewayProxyResponseEvent> responseEvent(int statusCode, String message, Map<String, String> headers) {
        return (IO)Kleisli.kleisli((Fn1)Alter.alter((Effect)Effect.effect(r -> IO.io(() -> r.setHeaders(headers))))).andThen(Kleisli.kleisli((Fn1)Alter.alter((Effect)Effect.effect(r -> IO.io(() -> r.setStatusCode(Integer.valueOf(statusCode))))))).andThen(Kleisli.kleisli((Fn1)Alter.alter((Effect)Effect.effect(r -> IO.io(() -> r.setBody(message)))))).apply((Object)new APIGatewayProxyResponseEvent());
    }
}

