/*
 * Decompiled with CFR 0.152.
 */
package org.movealong.bolt;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.jnape.palatable.lambda.adt.Either;
import com.jnape.palatable.lambda.functions.Effect;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.Alter;
import com.jnape.palatable.lambda.functions.builtin.fn2.AutoBracket;
import com.jnape.palatable.lambda.functions.specialized.Kleisli;
import com.jnape.palatable.lambda.io.IO;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class Bolt
implements RequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private static final Logger log = LoggerFactory.getLogger(Bolt.class);
    private final IO<APIGatewayProxyResponseEvent> handle;

    public Bolt() {
        Map<String, String> environment = System.getenv();
        String appName = environment.get("APP_NAME");
        String redisServer = environment.get("REDIS_SERVER");
        this.handle = IO.io(() -> log.info("Getting index")).discardL(Bolt.fetchCurrentIndex(appName, redisServer)).flatMap(e -> (IO)e.match(Bolt.errorResonse(), Bolt.successResponse()));
    }

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent request, Context context) {
        return (APIGatewayProxyResponseEvent)this.handle.unsafePerformIO();
    }

    private static IO<Either<Throwable, String>> fetchCurrentIndex(String appName, String redisServer) {
        return AutoBracket.autoBracket((IO)IO.io(() -> new Jedis(redisServer)).flatMap(Alter.alter(j -> IO.io(() -> ((Jedis)j).connect()))), jedis -> IO.io(() -> jedis.get(appName + ":index:current-content"))).safe();
    }

    private static Fn1<Throwable, IO<APIGatewayProxyResponseEvent>> errorResonse() {
        return ex -> IO.io(() -> log.error("Failed to serve request", ex)).discardL(Bolt.responseEvent(500, ex.getMessage(), Collections.singletonMap("Content-Type", "text/plain")));
    }

    private static Fn1<String, IO<APIGatewayProxyResponseEvent>> successResponse() {
        return idx -> IO.io(() -> log.info("Served current index")).discardL(Bolt.responseEvent(200, idx, Collections.singletonMap("Content-Type", "text/html")));
    }

    private static IO<APIGatewayProxyResponseEvent> responseEvent(int statusCode, String message, Map<String, String> headers) {
        return (IO)Kleisli.kleisli((Fn1)Alter.alter((Effect)Effect.effect(r -> IO.io(() -> r.setHeaders(headers))))).andThen(Kleisli.kleisli((Fn1)Alter.alter((Effect)Effect.effect(r -> IO.io(() -> r.setStatusCode(Integer.valueOf(statusCode))))))).andThen(Kleisli.kleisli((Fn1)Alter.alter((Effect)Effect.effect(r -> IO.io(() -> r.setBody(message)))))).apply((Object)new APIGatewayProxyResponseEvent());
    }
}

