/*
 * Decompiled with CFR 0.152.
 */
package org.movealong.bolt;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class Bolt
implements RequestHandler<APIGatewayProxyRequestEvent, APIGatewayProxyResponseEvent> {
    private static final Logger log = LoggerFactory.getLogger(Bolt.class);
    private final String appName;
    private final String redisServer;

    public Bolt() {
        Map<String, String> environment = System.getenv();
        this.appName = environment.get("APP_NAME");
        this.redisServer = environment.get("REDIS_SERVER");
    }

    public APIGatewayProxyResponseEvent handleRequest(APIGatewayProxyRequestEvent request, Context context) {
        APIGatewayProxyResponseEvent response = new APIGatewayProxyResponseEvent();
        try {
            response.setStatusCode(Integer.valueOf(200));
            response.setBody(this.getIndex());
            response.setHeaders(Collections.singletonMap("Content-Type", "text/html"));
            log.info("Served current index");
            return response;
        }
        catch (Throwable e) {
            log.error("Failed to serve request", e);
            response.setStatusCode(Integer.valueOf(500));
            response.setBody(e.getMessage());
            response.setHeaders(Collections.singletonMap("Content-Type", "text/plain"));
            return response;
        }
    }

    private String getIndex() {
        String index;
        try (Jedis jedis = new Jedis(this.redisServer);){
            jedis.connect();
            index = jedis.get(this.appName + ":index:current-content");
        }
        return index;
    }
}

