/*
 * Decompiled with CFR 0.152.
 */
package org.movealong.sly.app;

import com.jnape.palatable.lambda.functions.specialized.Kleisli;
import com.jnape.palatable.lambda.io.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.movealong.sly.app.App;
import org.movealong.sly.app.Runner;
import org.movealong.sly.app.Service;
import org.movealong.sly.app.ServiceException;
import org.movealong.sly.app.ServiceHandle;
import testsupport.matchers.IOMatcher;

class AppTest {
    AppTest() {
    }

    @Test
    void runsAService() {
        ServiceHandle handle = ServiceHandle.create();
        MatcherAssert.assertThat((Object)((IO)App.run((Kleisli)App.bind((ServiceHandle)handle, (Service)Service.service((IO)IO.io((Object)Runner.runner(() -> IO.io((Object)"service"))))).andThen(App.resolve((ServiceHandle)handle)))), (Matcher)IOMatcher.yieldsValue((Matcher)IsEqual.equalTo((Object)"service")));
    }

    @Test
    void runsAServiceWithDependencies() {
        ServiceHandle aKey = ServiceHandle.create();
        ServiceHandle bKey = ServiceHandle.create();
        ServiceHandle producerHandle = ServiceHandle.create();
        MatcherAssert.assertThat((Object)((IO)App.run((Kleisli)App.bind((ServiceHandle)aKey, (Service)Service.service((IO)IO.io((Object)"composed"))).andThen(App.bind((ServiceHandle)bKey, (Service)Service.service((IO)IO.io((Object)"service")))).andThen(App.bind((ServiceHandle)producerHandle, (Service)Service.service((ServiceHandle)aKey, (ServiceHandle)bKey, (a, b) -> Service.service((IO)IO.io((Object)Runner.runner(() -> IO.io((Object)(a + " " + b)))))))).andThen(App.resolve((ServiceHandle)producerHandle)))), (Matcher)IOMatcher.yieldsValue((Matcher)IsEqual.equalTo((Object)"composed service")));
    }

    @Test
    void detectsDuplicateBindings() {
        ServiceHandle key = ServiceHandle.create();
        ServiceHandle producerHandle = ServiceHandle.create();
        Assertions.assertThrows(ServiceException.class, () -> App.run((Kleisli)App.bind((ServiceHandle)key, (Service)Service.service((IO)IO.io((Object)"first"))).andThen(App.bind((ServiceHandle)key, (Service)Service.service((IO)IO.io((Object)"second")))).andThen(App.bind((ServiceHandle)producerHandle, (Service)Service.service((ServiceHandle)key, s -> Service.service((IO)IO.io((Object)Runner.runner(() -> IO.io((Object)("resolved: %" + s)))))))).andThen(App.resolve((ServiceHandle)producerHandle))));
    }

    @Test
    void detectsResolutionCycles() {
        ServiceHandle aKey = ServiceHandle.create();
        ServiceHandle bKey = ServiceHandle.create();
        ServiceHandle producerHandle = ServiceHandle.create();
        Assertions.assertThrows(ServiceException.class, () -> App.run((Kleisli)App.bind((ServiceHandle)aKey, (Service)Service.service((ServiceHandle)bKey, b -> Service.service((IO)IO.io((Object)("service A depends on " + b))))).andThen(App.bind((ServiceHandle)bKey, (Service)Service.service((ServiceHandle)aKey, a -> Service.service((IO)IO.io((Object)("service B depends on " + a)))))).andThen(App.bind((ServiceHandle)producerHandle, (Service)Service.service((ServiceHandle)aKey, a -> Service.service((IO)IO.io((Object)Runner.runner(() -> IO.io((Object)("resolved: " + a)))))))).andThen(App.resolve((ServiceHandle)producerHandle))));
    }

    @Test
    void detectsMissingDependency() {
        ServiceHandle aKey = ServiceHandle.create();
        ServiceHandle bKey = ServiceHandle.create();
        ServiceHandle producerHandle = ServiceHandle.create();
        Assertions.assertThrows(ServiceException.class, () -> App.run((Kleisli)App.bind((ServiceHandle)aKey, (Service)Service.service((IO)IO.io((Object)"composed"))).andThen(App.bind((ServiceHandle)producerHandle, (Service)Service.service((ServiceHandle)aKey, (ServiceHandle)bKey, (a, b) -> Service.service((IO)IO.io((Object)Runner.runner(() -> IO.io((Object)(a + " " + b)))))))).andThen(App.resolve((ServiceHandle)producerHandle))));
    }
}

