/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.security.SecureRandom;
import org.mozilla.zest.core.v1.ZestAssignment;
import org.mozilla.zest.core.v1.ZestResponse;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestAssignRandomInteger
extends ZestAssignment {
    private int minInt = 0;
    private int maxInt = Integer.MAX_VALUE;
    private transient SecureRandom rnd = new SecureRandom();

    public ZestAssignRandomInteger() {
    }

    public ZestAssignRandomInteger(String variableName) {
        super(variableName);
    }

    public ZestAssignRandomInteger(String variableName, int minInt, int maxInt) {
        super(variableName);
        this.minInt = minInt;
        this.maxInt = maxInt;
    }

    @Override
    public String assign(ZestResponse response, ZestRuntime runtime) {
        int val = this.minInt + this.rnd.nextInt(this.maxInt - this.minInt);
        return Integer.toString(val);
    }

    @Override
    public ZestAssignRandomInteger deepCopy() {
        ZestAssignRandomInteger copy = new ZestAssignRandomInteger(this.getVariableName(), this.minInt, this.maxInt);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    public int getMinInt() {
        return this.minInt;
    }

    public void setMinInt(int minInt) {
        this.minInt = minInt;
    }

    public int getMaxInt() {
        return this.maxInt;
    }

    public void setMaxInt(int maxInt) {
        this.maxInt = maxInt;
    }
}

