/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import org.mozilla.zest.core.v1.ZestClient;
import org.mozilla.zest.core.v1.ZestClientFailException;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestRuntime;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class ZestClientScreenshot
extends ZestClient {
    private String windowHandle;
    private String filePath;
    private String variableName;

    public ZestClientScreenshot() {
    }

    public ZestClientScreenshot(String windowHandle, String filePath, String variableName) {
        this.windowHandle = windowHandle;
        this.filePath = filePath;
        this.variableName = variableName;
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public String invoke(ZestRuntime runtime) throws ZestClientFailException {
        boolean saveToFile;
        WebDriver wd = runtime.getWebDriver(this.getWindowHandle());
        if (wd == null) {
            throw new ZestClientFailException((ZestElement)this, "No client: " + runtime.getVariable(this.getWindowHandle()));
        }
        if (!(wd instanceof TakesScreenshot)) {
            throw new ZestClientFailException((ZestElement)this, "Client does not take screenshots: " + runtime.getVariable(this.getWindowHandle()));
        }
        boolean saveToVariable = this.variableName != null && !this.variableName.isEmpty();
        boolean bl = saveToFile = this.filePath != null && !this.filePath.isEmpty();
        if (!saveToVariable && !saveToFile) {
            throw new ZestClientFailException((ZestElement)this, "No file nor variable specified.");
        }
        byte[] screenshot = (byte[])((TakesScreenshot)wd).getScreenshotAs(OutputType.BYTES);
        if (saveToVariable) {
            runtime.setVariable(this.variableName, Base64.getEncoder().encodeToString(screenshot));
        }
        if (saveToFile) {
            String finalFilePath = runtime.replaceVariablesInString(this.filePath, false);
            try {
                Files.copy(new ByteArrayInputStream(screenshot), Paths.get(finalFilePath, new String[0]), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new ZestClientFailException(this, "Failed to save the screenshot to file.", e);
            }
        }
        return null;
    }

    @Override
    public ZestClientScreenshot deepCopy() {
        ZestClientScreenshot copy = new ZestClientScreenshot(this.getWindowHandle(), this.getFilePath(), this.getVariableName());
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    @Override
    public boolean isPassive() {
        return true;
    }
}

