/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mozilla.zest.core.v1.ZestAssignment;
import org.mozilla.zest.core.v1.ZestContainer;
import org.mozilla.zest.core.v1.ZestControlLoopBreak;
import org.mozilla.zest.core.v1.ZestControlLoopNext;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestLoopState;
import org.mozilla.zest.core.v1.ZestLoopTokenSet;
import org.mozilla.zest.core.v1.ZestRuntime;
import org.mozilla.zest.core.v1.ZestStatement;

public abstract class ZestLoop<T>
extends ZestStatement
implements ZestContainer,
Enumeration<ZestStatement> {
    private List<ZestStatement> statements = new LinkedList<ZestStatement>();
    private String variableName = "";
    private transient ZestLoopState<T> currentState;
    private transient int stmtIndex = 0;
    private transient ZestRuntime runtime = null;

    protected ZestLoop() {
    }

    protected ZestLoop(int index) {
        super(index);
    }

    public ZestLoop(String variableName) {
        this.variableName = variableName;
    }

    protected void init(ZestLoopTokenSet<T> set, List<ZestStatement> statements) {
        this.statements = statements;
        this.currentState = set.getFirstState();
    }

    public void init(ZestRuntime runtime) {
        this.runtime = runtime;
        this.currentState = this.getSet().getFirstState();
    }

    protected void setSet(ZestLoopTokenSet<T> newSet) {
        this.setCurrentState(newSet.getFirstState());
    }

    public List<ZestStatement> setStatements(List<ZestStatement> stmts) {
        List<ZestStatement> oldStatements = this.statements;
        this.statements = stmts;
        return oldStatements;
    }

    public List<ZestStatement> getStatements() {
        return this.statements;
    }

    @Override
    public List<ZestStatement> getChildren() {
        return Collections.unmodifiableList(this.getStatements());
    }

    protected boolean loop(ZestLoopTokenSet<T> set) {
        return this.currentState.increase(set);
    }

    protected void endLoop(ZestLoopTokenSet<T> set) {
        this.currentState.toLastState(set);
    }

    public void addStatement(ZestStatement stmt) {
        this.add(this.statements.size(), stmt);
    }

    public void add(int index, ZestStatement stmt) {
        ZestStatement prev = this;
        if (index == this.statements.size()) {
            this.statements.add(stmt);
        } else {
            this.statements.add(index, stmt);
        }
        if (index > 0) {
            prev = this.statements.get(index - 1);
        }
        stmt.insertAfter(prev);
    }

    public ZestLoopState<T> getCurrentState() {
        return this.currentState;
    }

    protected void setCurrentState(ZestLoopState<T> newState) {
        this.currentState = newState;
    }

    public T getCurrentToken() {
        return this.currentState.getCurrentToken();
    }

    public int getCurrentIndex() {
        return this.currentState.getCurrentIndex();
    }

    public int getCurrentStatementIndex() {
        return this.stmtIndex;
    }

    public abstract ZestLoopTokenSet<T> getSet();

    @Override
    public ZestStatement getLast() {
        if (this.statements == null || this.statements.isEmpty()) {
            return this;
        }
        return this.statements.get(this.statements.size() - 1);
    }

    @Override
    public ZestStatement getStatement(int index) {
        for (ZestStatement zr : this.statements) {
            ZestStatement stmt;
            if (zr.getIndex() == index) {
                return zr;
            }
            if (!(zr instanceof ZestContainer) || (stmt = ((ZestContainer)((Object)zr)).getStatement(index)) == null) continue;
            return stmt;
        }
        return null;
    }

    @Override
    public int getIndex(ZestStatement child) {
        if (this.statements.contains(child)) {
            return this.statements.indexOf(child);
        }
        return -1;
    }

    @Override
    public void move(int index, ZestStatement stmt) {
        if (!this.statements.contains(stmt)) {
            throw new IllegalArgumentException("Not a direct child: " + stmt);
        }
        this.statements.remove(stmt);
        this.statements.add(index, stmt);
    }

    @Override
    public boolean isSameSubclass(ZestElement ze) {
        return ze instanceof ZestLoop;
    }

    @Override
    public ZestStatement getChildBefore(ZestStatement child) {
        int childIndex;
        if (this.statements.contains(child) && (childIndex = this.statements.indexOf(child)) > 1) {
            return this.statements.get(childIndex - 1);
        }
        return null;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> tokens = new HashSet<String>();
        tokens.add(this.getVariableName());
        for (ZestStatement stmt : this.statements) {
            if (stmt instanceof ZestContainer) {
                tokens.addAll(((ZestContainer)((Object)stmt)).getVariableNames());
                continue;
            }
            if (!(stmt instanceof ZestAssignment)) continue;
            tokens.add(((ZestAssignment)stmt).getVariableName());
        }
        return tokens;
    }

    @Override
    public void setPrefix(String oldPrefix, String newPrefix) throws MalformedURLException {
        for (ZestStatement stmt : this.statements) {
            stmt.setPrefix(oldPrefix, newPrefix);
        }
    }

    @Override
    public abstract ZestLoop<T> deepCopy();

    @Override
    public boolean hasMoreElements() {
        boolean isLastStmt;
        boolean isLastLoop = this.isLastState();
        if (isLastLoop) {
            return false;
        }
        boolean bl = isLastStmt = this.stmtIndex == this.statements.size();
        if (isLastStmt) {
            return false;
        }
        return !(this.statements.get(this.stmtIndex) instanceof ZestControlLoopBreak);
    }

    public abstract boolean isLastState();

    protected abstract void increase();

    public abstract void toLastState();

    @Override
    public ZestStatement nextElement() {
        ZestStatement newStatement;
        int currentStmt = this.stmtIndex++;
        if (this.stmtIndex == this.statements.size()) {
            this.increase();
            this.stmtIndex = 0;
        }
        if ((newStatement = this.statements.get(currentStmt)) instanceof ZestControlLoopBreak) {
            this.onControlBreak();
            return null;
        }
        if (newStatement instanceof ZestControlLoopNext) {
            this.onControlNext();
            return this.statements.get(this.stmtIndex);
        }
        return this.statements.get(currentStmt);
    }

    public void onControlBreak() {
        this.toLastState();
        this.stmtIndex = this.statements.size();
    }

    public void onControlNext() {
        this.increase();
        this.stmtIndex = 0;
    }

    public List<ZestStatement> copyStatements() {
        LinkedList<ZestStatement> copiedStatements = new LinkedList<ZestStatement>();
        if (this.getStatements() == null) {
            return copiedStatements;
        }
        for (ZestStatement stmt : this.getStatements()) {
            copiedStatements.add(stmt.deepCopy());
        }
        return copiedStatements;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String name) {
        this.variableName = name;
    }

    @Override
    public boolean isPassive() {
        return true;
    }

    @Override
    protected ZestStatement setPrev(ZestStatement prev) {
        for (ZestStatement statement : this.statements) {
            if (prev != null) {
                prev.setNext(statement);
            }
            prev = statement.setPrev(prev);
        }
        return prev;
    }

    protected ZestRuntime getRuntime() {
        return this.runtime;
    }
}

