/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestLoopTokenSet;

public abstract class ZestLoopState<T>
extends ZestElement {
    private T currentToken;
    private int currentIndex = 0;

    protected ZestLoopState() {
    }

    protected ZestLoopState(ZestLoopTokenSet<T> initializationTokenSet) {
        if (initializationTokenSet == null) {
            throw new IllegalArgumentException("a null token set is not allowed");
        }
        if (initializationTokenSet.size() > 0) {
            this.currentToken = initializationTokenSet.getToken(0);
            this.currentIndex = 0;
        }
    }

    public T getCurrentToken() {
        return this.currentToken;
    }

    protected T setCurrentToken(T newToken) {
        T oldToken = this.getCurrentToken();
        this.currentToken = newToken;
        return oldToken;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    protected void increaseIndex() {
        ++this.currentIndex;
    }

    protected void setIndex(int newIndex) {
        this.currentIndex = newIndex;
    }

    protected abstract boolean increase(ZestLoopTokenSet<T> var1);

    public void toLastState(ZestLoopTokenSet<T> set) {
        if (set == null) {
            return;
        }
        this.setIndex(set.size());
        this.setCurrentToken(null);
    }

    @Override
    public abstract ZestLoopState<T> deepCopy();

    public boolean isLastState(ZestLoopTokenSet<T> set) {
        return this.getCurrentIndex() >= set.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.currentIndex;
        result = 31 * result + (this.currentToken == null ? 0 : this.currentToken.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ZestLoopState other = (ZestLoopState)obj;
        if (this.currentIndex != other.currentIndex) {
            return false;
        }
        return !(this.currentToken == null ? other.currentToken != null : !this.currentToken.equals(other.currentToken));
    }
}

