/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestLoopStateString;
import org.mozilla.zest.core.v1.ZestLoopTokenSet;

public class ZestLoopTokenStringSet
extends ZestElement
implements ZestLoopTokenSet<String> {
    private List<String> tokens = new LinkedList<String>();

    public ZestLoopTokenStringSet() {
    }

    public ZestLoopTokenStringSet(List<String> tokens) {
        this.tokens = tokens;
    }

    public ZestLoopTokenStringSet(String[] values) {
        this.tokens = new LinkedList<String>();
        Collections.addAll(this.tokens, values);
    }

    public void addToken(String token) {
        if (this.tokens == null) {
            this.tokens = new LinkedList<String>();
        }
        this.tokens.add(token);
    }

    @Override
    public String getToken(int index) {
        if (this.tokens == null || this.tokens.isEmpty()) {
            return null;
        }
        return this.tokens.get(index);
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    @Override
    public int indexOf(String token) {
        return this.tokens.indexOf(token);
    }

    @Override
    public String getLastToken() {
        if (this.tokens == null || this.tokens.isEmpty()) {
            return null;
        }
        return this.tokens.get(this.tokens.size() - 1);
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public ZestLoopTokenStringSet deepCopy() {
        if (this.tokens == null) {
            return new ZestLoopTokenStringSet();
        }
        ZestLoopTokenStringSet copy = new ZestLoopTokenStringSet();
        for (String token : this.tokens) {
            copy.addToken(token);
        }
        return copy;
    }

    public String removeToken(int index) {
        return this.tokens.remove(index);
    }

    public String replace(int indexOfReplace, String newToken) {
        String replaced = this.tokens.get(indexOfReplace);
        this.tokens.remove(indexOfReplace);
        this.tokens.add(indexOfReplace, newToken);
        return replaced;
    }

    public ZestLoopStateString getFirstState() {
        ZestLoopStateString firstState = new ZestLoopStateString(this);
        return firstState;
    }
}

