/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.zest.core.v1.ZestAuthentication;
import org.mozilla.zest.core.v1.ZestHttpAuthentication;
import org.mozilla.zest.core.v1.ZestJSON;
import org.mozilla.zest.core.v1.ZestScript;
import org.mozilla.zest.impl.ZestBasicRunner;
import org.mozilla.zest.impl.ZestPrinter;

public class CmdLine {
    private static final String USAGE = "Usage: -script <file> [-summary | -list] [-debug] [-timeout <timeout for requests in seconds>] [-prefix <http://prefix>] [-token <name>=<value>]...\n    [-http-auth-site <site> -http-auth-realm <realm> -http-auth-user <user> -http-auth-password <password>] \n    [-insecure <skip the SSL certificate check>]    For more information about Zest visit https://developer.mozilla.org/en-US/docs/Zest";

    public static void main(String[] args) {
        ZestScript zs;
        StringBuilder sb;
        File script = null;
        Mode mode = null;
        String prefix = null;
        HashMap<String, String> tokens = new HashMap<String, String>();
        String httpAuthSite = null;
        String httpAuthRealm = null;
        String httpAuthUser = null;
        String httpAuthPassword = null;
        boolean debug = false;
        boolean skipSSLCertificateCheck = false;
        Integer timeoutInSeconds = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-summary")) {
                if (mode != null) {
                    CmdLine.error(USAGE);
                    return;
                }
                mode = Mode.summary;
                continue;
            }
            if (args[i].equals("-list")) {
                if (mode != null) {
                    CmdLine.error(USAGE);
                    return;
                }
                mode = Mode.list;
                continue;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-prefix")) {
                if (i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                prefix = args[++i];
                continue;
            }
            if (args[i].equals("-script")) {
                if (script != null || i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                script = new File(args[++i]);
                continue;
            }
            if (args[i].equals("-token")) {
                if (i >= args.length - 1 || args[i + 1].indexOf("=") < 0) {
                    CmdLine.error(USAGE);
                    return;
                }
                int eqInd = args[++i].indexOf("=");
                tokens.put(args[i].substring(0, eqInd), args[i].substring(eqInd + 1));
                continue;
            }
            if (args[i].equals("-http-auth-site")) {
                if (i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                httpAuthSite = args[++i];
                continue;
            }
            if (args[i].equals("-http-auth-realm")) {
                if (i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                httpAuthRealm = args[++i];
                continue;
            }
            if (args[i].equals("-http-auth-user")) {
                if (i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                httpAuthUser = args[++i];
                continue;
            }
            if (args[i].equals("-http-auth-password")) {
                if (i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                httpAuthPassword = args[++i];
                continue;
            }
            if (args[i].equals("-timeout")) {
                if (i >= args.length - 1) {
                    CmdLine.error(USAGE);
                    return;
                }
                ++i;
                try {
                    timeoutInSeconds = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException e) {
                    CmdLine.error("The timeout must be a number but was: " + args[i]);
                    CmdLine.error(USAGE);
                }
                continue;
            }
            if (args[i].equals("-insecure")) {
                skipSSLCertificateCheck = true;
                continue;
            }
            CmdLine.error("Parameter not recognised: " + args[i]);
            CmdLine.error(USAGE);
            return;
        }
        if (script == null) {
            CmdLine.error(USAGE);
            return;
        }
        if (!script.exists()) {
            CmdLine.error("Script " + script.getAbsolutePath() + " does not exist");
            return;
        }
        try (BufferedReader fr = new BufferedReader(new FileReader(script));){
            String line;
            sb = new StringBuilder();
            while ((line = fr.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            CmdLine.error("Error reading file " + script.getAbsolutePath() + ": " + e);
            return;
        }
        try {
            zs = (ZestScript)ZestJSON.fromString(sb.toString());
            if (!"0.8".equals(zs.getZestVersion())) {
                CmdLine.error("Error Zest version " + zs.getZestVersion() + " not supported");
                return;
            }
        }
        catch (Exception e) {
            CmdLine.error("Error loading script " + script.getAbsolutePath() + ": " + e);
            return;
        }
        if (mode == null) {
            mode = Mode.run;
        }
        switch (mode) {
            case summary: {
                ZestPrinter.summary(zs);
                break;
            }
            case list: {
                ZestPrinter.list(zs);
                break;
            }
            default: {
                if (prefix != null) {
                    try {
                        zs.setPrefix(zs.getPrefix(), prefix);
                    }
                    catch (MalformedURLException e) {
                        CmdLine.error("Invalid prefix: " + e);
                        return;
                    }
                }
                if (httpAuthSite != null) {
                    ArrayList<ZestAuthentication> authList = new ArrayList<ZestAuthentication>();
                    authList.add(new ZestHttpAuthentication(httpAuthSite, httpAuthRealm, httpAuthUser, httpAuthPassword));
                    zs.setAuthentication(authList);
                }
                CmdLine.run(zs, tokens, debug, timeoutInSeconds, skipSSLCertificateCheck);
            }
        }
    }

    private static void error(String str) {
        System.err.println(str);
    }

    private static void run(ZestScript zs, Map<String, String> parameters, boolean debug, Integer timeoutInSeconds, boolean skipSSLCertificateCheck) {
        ZestBasicRunner zbr = new ZestBasicRunner(timeoutInSeconds, skipSSLCertificateCheck);
        zbr.setOutputWriter(new OutputStreamWriter(System.out));
        zbr.setStopOnAssertFail(false);
        zbr.setDebug(debug);
        try {
            zbr.run(zs, parameters);
        }
        catch (Exception e) {
            System.out.println("Error running script: " + e);
            e.printStackTrace();
        }
    }

    private static enum Mode {
        run,
        summary,
        list;

    }
}

