/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.zest.core.v1.ZestAssignFailException;
import org.mozilla.zest.core.v1.ZestAssignment;
import org.mozilla.zest.core.v1.ZestResponse;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestAssignStringDelimiters
extends ZestAssignment {
    private String prefix;
    private String postfix;
    private String location;
    public static final transient String LOC_HEAD = "HEAD";
    public static final transient String LOC_BODY = "BODY";
    private static final transient Set<String> LOCATIONS = new HashSet<String>(Arrays.asList("HEAD", "BODY"));

    public ZestAssignStringDelimiters() {
    }

    public ZestAssignStringDelimiters(String variableName, String location, String prefix, String postfix) {
        super(variableName);
        this.location = location;
        this.setPrefix(prefix);
        this.setPostfix(postfix);
    }

    public ZestAssignStringDelimiters(int index) {
        super(index);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (!LOCATIONS.contains(location)) {
            throw new IllegalArgumentException("Unsupported location: " + location);
        }
        this.location = location;
    }

    @Override
    public ZestAssignStringDelimiters deepCopy() {
        ZestAssignStringDelimiters copy = new ZestAssignStringDelimiters(this.getIndex());
        copy.setVariableName(this.getVariableName());
        copy.location = this.location;
        copy.setPrefix(this.prefix);
        copy.setPostfix(this.postfix);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    private String getVariableValue(String str) {
        int endIndex;
        int startIndex;
        if (str != null && this.prefix != null && this.postfix != null && (startIndex = str.indexOf(this.prefix)) >= 0 && (endIndex = str.indexOf(this.postfix, startIndex += this.prefix.length())) >= 0) {
            return str.substring(startIndex, endIndex);
        }
        return null;
    }

    @Override
    public String assign(ZestResponse response, ZestRuntime runtime) throws ZestAssignFailException {
        String value;
        if (this.prefix == null || this.prefix.length() == 0) {
            throw new ZestAssignFailException(this, "Null prefix");
        }
        if (this.postfix == null || this.postfix.length() == 0) {
            throw new ZestAssignFailException(this, "Null postfix");
        }
        if (response == null) {
            throw new ZestAssignFailException(this, "Null response");
        }
        if (LOC_HEAD.equals(this.location)) {
            value = this.getVariableValue(response.getHeaders());
        } else if (LOC_BODY.equals(this.location)) {
            value = this.getVariableValue(response.getBody());
        } else {
            value = this.getVariableValue(response.getHeaders());
            if (value == null) {
                value = this.getVariableValue(response.getBody());
            }
        }
        if (value != null) {
            return value;
        }
        throw new ZestAssignFailException(this, "Failed to find value between '" + this.prefix + "' and '" + this.postfix + "'");
    }
}

