/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestClient;
import org.mozilla.zest.core.v1.ZestClientFailException;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestRuntime;
import org.mozilla.zest.core.v1.ZestStatement;
import org.openqa.selenium.WebDriver;

public class ZestClientSwitchToFrame
extends ZestClient {
    private String windowHandle = null;
    private int frameIndex = -1;
    private String frameName = null;
    private boolean parent = false;

    public ZestClientSwitchToFrame() {
    }

    public ZestClientSwitchToFrame(String windowHandle, int index, String name, boolean parent) {
        this.windowHandle = windowHandle;
        this.frameIndex = index;
        this.frameName = name;
        this.parent = parent;
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestClientSwitchToFrame copy = new ZestClientSwitchToFrame(this.windowHandle, this.frameIndex, this.frameName, this.parent);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    public String getFrameName() {
        return this.frameName;
    }

    public boolean isParent() {
        return this.parent;
    }

    public void setFrameIndex(int index) {
        this.frameIndex = index;
    }

    public void setFrameName(String name) {
        this.frameName = name;
    }

    public void setParent(boolean parent) {
        this.parent = parent;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public String invoke(ZestRuntime runtime) throws ZestClientFailException {
        WebDriver wd = runtime.getWebDriver(this.getWindowHandle());
        if (wd == null) {
            throw new ZestClientFailException((ZestElement)this, "No client: " + runtime.getVariable(this.getWindowHandle()));
        }
        if (this.frameIndex >= 0) {
            wd.switchTo().frame(this.frameIndex);
        } else if (this.isParent()) {
            wd.switchTo().parentFrame();
        } else {
            wd.switchTo().frame(this.frameName);
        }
        return this.windowHandle;
    }
}

