/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestExpression;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestExpressionEquals
extends ZestExpression {
    private String value;
    private String variableName;
    private boolean caseExact = false;

    public ZestExpressionEquals() {
        this("", null, false, false);
    }

    public ZestExpressionEquals(String variableName, String regex) {
        this(variableName, regex, false, false);
    }

    public ZestExpressionEquals(String variableName, String value, boolean caseExact, boolean inverse) {
        super(inverse);
        this.variableName = variableName;
        this.value = value;
        this.caseExact = caseExact;
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        String str = runtime.getVariable(this.variableName);
        if (str == null) {
            return false;
        }
        String val = runtime.replaceVariablesInString(this.value, false);
        if (this.caseExact) {
            return str.equals(val);
        }
        return str.equalsIgnoreCase(val);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public ZestExpressionEquals deepCopy() {
        return new ZestExpressionEquals(this.getVariableName(), this.getValue(), this.isCaseExact(), this.isInverse());
    }
}

