/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestExpression;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestExpressionIsInteger
extends ZestExpression {
    private String variableName;

    public ZestExpressionIsInteger() {
        this("");
    }

    public ZestExpressionIsInteger(String variableName) {
        this(variableName, false);
    }

    public ZestExpressionIsInteger(String variableName, boolean inverse) {
        super(inverse);
        this.variableName = variableName;
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        String str = runtime.getVariable(this.variableName);
        if (str == null) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public ZestExpressionIsInteger deepCopy() {
        return new ZestExpressionIsInteger(this.getVariableName(), this.isInverse());
    }
}

