/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.util.Collections;
import java.util.List;
import org.mozilla.zest.core.v1.ZestClientFailException;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestLoopClientElements;
import org.mozilla.zest.core.v1.ZestLoopStateClientElements;
import org.mozilla.zest.core.v1.ZestLoopTokenSet;
import org.mozilla.zest.core.v1.ZestLoopTokenStringSet;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ZestLoopTokenClientElementsSet
extends ZestElement
implements ZestLoopTokenSet<String> {
    private String windowHandle = null;
    private String type = null;
    private String element = null;
    private String attribute = null;
    private transient ZestLoopTokenStringSet convertedSet = null;
    private transient ZestLoopClientElements loop;

    public ZestLoopTokenClientElementsSet(ZestLoopClientElements loop, String windowHandle, String type, String element, String attribute) {
        this.loop = loop;
        this.windowHandle = windowHandle;
        this.type = type;
        this.element = element;
        this.attribute = attribute;
    }

    protected ZestLoopTokenStringSet getConvertedSet() throws ZestClientFailException {
        if (this.convertedSet == null) {
            List weList;
            if (this.loop == null) {
                return null;
            }
            ZestLoopTokenStringSet set = new ZestLoopTokenStringSet();
            WebDriver wd = this.loop.getRuntime().getWebDriver(this.getWindowHandle());
            if ("className".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.className((String)this.getElement()));
            } else if ("cssSelector".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.cssSelector((String)this.getElement()));
            } else if ("id".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.id((String)this.getElement()));
            } else if ("linkText".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.linkText((String)this.getElement()));
            } else if ("name".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.name((String)this.getElement()));
            } else if ("partialLinkText".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.partialLinkText((String)this.getElement()));
            } else if ("tagName".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.tagName((String)this.getElement()));
            } else if ("xpath".equalsIgnoreCase(this.type)) {
                weList = wd.findElements(By.xpath((String)this.getElement()));
            } else {
                throw new ZestClientFailException((ZestElement)this, "Unsupported type: " + this.type);
            }
            for (WebElement we : weList) {
                String val = this.attribute == null || this.attribute.length() == 0 ? we.getText() : we.getAttribute(this.attribute);
                if (val == null || val.length() <= 0) continue;
                set.addToken(val);
            }
            this.convertedSet = set;
        }
        return this.convertedSet;
    }

    @Override
    public String getToken(int index) {
        try {
            return this.getConvertedSet().getToken(index);
        }
        catch (ZestClientFailException e) {
            return null;
        }
    }

    public List<String> getTokens() {
        try {
            return Collections.unmodifiableList(this.getConvertedSet().getTokens());
        }
        catch (ZestClientFailException e) {
            return null;
        }
    }

    @Override
    public int indexOf(String token) {
        try {
            return this.getConvertedSet().indexOf(token);
        }
        catch (ZestClientFailException e) {
            return -1;
        }
    }

    @Override
    public String getLastToken() {
        try {
            return this.getConvertedSet().getLastToken();
        }
        catch (ZestClientFailException e) {
            return null;
        }
    }

    @Override
    public int size() {
        try {
            return this.getConvertedSet().size();
        }
        catch (ZestClientFailException e) {
            return -1;
        }
    }

    @Override
    public ZestLoopTokenClientElementsSet deepCopy() {
        return new ZestLoopTokenClientElementsSet(this.loop, this.windowHandle, this.type, this.element, this.attribute);
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public String getElement() {
        return this.element;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public String getType() {
        return this.type;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public void setConvertedSet(ZestLoopTokenStringSet convertedSet) {
        this.convertedSet = convertedSet;
    }

    public ZestLoopStateClientElements getFirstState() {
        try {
            return new ZestLoopStateClientElements(this);
        }
        catch (ZestClientFailException e) {
            return null;
        }
    }

    public void setLoop(ZestLoopClientElements loop) {
        this.loop = loop;
    }
}

