/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestAssignFailException;
import org.mozilla.zest.core.v1.ZestAssignment;
import org.mozilla.zest.core.v1.ZestResponse;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestAssignCalc
extends ZestAssignment {
    public static final String OPERAND_ADD = "add";
    public static final String OPERAND_SUBTRACT = "subtract";
    public static final String OPERAND_MULTIPLY = "multiply";
    public static final String OPERAND_DIVIDE = "divide";
    private String operandA = null;
    private String operandB = null;
    private String operation = null;

    public ZestAssignCalc() {
    }

    public ZestAssignCalc(String variableName) {
        super(variableName);
    }

    public ZestAssignCalc(String variableName, String operandA, String operation, String operandB) {
        super(variableName);
        this.operandA = operandA;
        this.operation = operation;
        this.operandB = operandB;
    }

    @Override
    public String assign(ZestResponse response, ZestRuntime runtime) throws ZestAssignFailException {
        int operB;
        int operA;
        try {
            operA = Integer.parseInt(runtime.replaceVariablesInString(this.operandA, false));
        }
        catch (NumberFormatException e) {
            throw new ZestAssignFailException(this, "operandA not a number");
        }
        try {
            operB = Integer.parseInt(runtime.replaceVariablesInString(this.operandB, false));
        }
        catch (NumberFormatException e) {
            throw new ZestAssignFailException(this, "operandB not a number");
        }
        if (OPERAND_ADD.equals(this.operation)) {
            return Integer.toString(operA + operB);
        }
        if (OPERAND_SUBTRACT.equals(this.operation)) {
            return Integer.toString(operA - operB);
        }
        if (OPERAND_MULTIPLY.equals(this.operation)) {
            return Integer.toString(operA * operB);
        }
        if (OPERAND_DIVIDE.equals(this.operation)) {
            return Integer.toString(operA / operB);
        }
        throw new ZestAssignFailException(this, "Invalid operation");
    }

    @Override
    public ZestAssignCalc deepCopy() {
        ZestAssignCalc copy = new ZestAssignCalc(this.getVariableName(), this.operandA, this.operation, this.operandB);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    public String getOperandA() {
        return this.operandA;
    }

    public String getOperandB() {
        return this.operandB;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperandA(String operandA) {
        this.operandA = operandA;
    }

    public void setOperandB(String operandB) {
        this.operandB = operandB;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

