/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.mozilla.zest.core.v1.ZestAssignFailException;
import org.mozilla.zest.core.v1.ZestAssignment;
import org.mozilla.zest.core.v1.ZestResponse;
import org.mozilla.zest.core.v1.ZestRuntime;
import org.mozilla.zest.core.v1.ZestStatement;

public class ZestAssignFromElement
extends ZestAssignment {
    private boolean filterElementName;
    private String elementNameFilter;
    private boolean filterAttributeValue;
    private String attributeNameFilter;
    private String attributeValueFilter;
    private int attributeValueFilterFlags;
    private transient Pattern attributeValueFilterPattern;
    private boolean reverseFilteredElements;
    private int elementIndex;
    private boolean returnElement;
    private boolean returnAttribute;
    private String returnedAttributeName;

    public ZestAssignFromElement() {
    }

    public ZestAssignFromElement(String variableName) {
        super(variableName);
    }

    @Override
    public String assign(ZestResponse response, ZestRuntime runtime) throws ZestAssignFailException {
        if (response == null) {
            throw new ZestAssignFailException(this, "Null response");
        }
        Source src = new Source((CharSequence)response.getBody());
        List<Element> elementsFilteredByElementName = this.filterByElementNameIfConfigured(src);
        List<Element> elementsFilteredByAttributeValue = this.filterByAttributeValueIfConfigured(elementsFilteredByElementName);
        List<Element> elements = this.reverseIfConfigured(elementsFilteredByAttributeValue);
        Element element = this.findElementAtIndex(elements);
        if (element == null) {
            return null;
        }
        return this.getReturnValue(element);
    }

    private String getReturnValue(Element element) throws ZestAssignFailException {
        if (this.returnElement) {
            return element.getContent().toString();
        }
        if (this.returnAttribute) {
            return element.getAttributeValue(this.returnedAttributeName);
        }
        throw new ZestAssignFailException(this, "A selection method must be configured");
    }

    private Element findElementAtIndex(List<Element> elements) {
        if (this.indexIsOutOfRange(elements)) {
            return null;
        }
        return elements.get(this.elementIndex);
    }

    private boolean indexIsOutOfRange(List<Element> elements) {
        return elements.isEmpty() || this.elementIndex >= elements.size();
    }

    private List<Element> reverseIfConfigured(List<Element> elements) {
        if (this.reverseFilteredElements) {
            Collections.reverse(elements);
            return elements;
        }
        return elements;
    }

    private List<Element> filterByElementNameIfConfigured(Source source) {
        if (this.filterElementName) {
            return source.getAllElements(this.elementNameFilter);
        }
        return source.getAllElements();
    }

    private List<Element> filterByAttributeValueIfConfigured(List<Element> elements) throws ZestAssignFailException {
        if (this.filterAttributeValue) {
            ArrayList<Element> matchingElements = new ArrayList<Element>();
            for (Element element : elements) {
                if (!this.isMatchingAttributeFilter(element)) continue;
                matchingElements.add(element);
            }
            return matchingElements;
        }
        return elements;
    }

    private boolean isMatchingAttributeFilter(Element element) throws ZestAssignFailException {
        String attributeValue;
        if (this.attributeValueFilterPattern == null) {
            try {
                this.attributeValueFilterPattern = Pattern.compile(this.attributeValueFilter, this.attributeValueFilterFlags);
            }
            catch (IllegalArgumentException ex) {
                throw new ZestAssignFailException(this, ex.getMessage() + "\r\nRegEx:'" + this.attributeValueFilter + "' with Flags:'" + this.attributeValueFilterFlags + "' can not be compiled to pattern.");
            }
        }
        if ((attributeValue = element.getAttributeValue(this.attributeNameFilter)) == null) {
            return false;
        }
        Matcher matcher = this.attributeValueFilterPattern.matcher(attributeValue);
        return matcher.matches();
    }

    public ZestAssignFromElement whereElementIs(String elementName) {
        this.filterElementName = true;
        this.elementNameFilter = elementName;
        return this;
    }

    public ZestAssignFromElement whereAttributeIs(String attributeName, String attributeValueRegExp) {
        return this.whereAttributeIs(attributeName, attributeValueRegExp, 0);
    }

    public ZestAssignFromElement whereAttributeIs(String attributeName, String attributeValueRegExp, int flags) {
        this.filterAttributeValue = true;
        this.attributeNameFilter = attributeName;
        this.attributeValueFilter = attributeValueRegExp;
        this.attributeValueFilterFlags = flags;
        this.attributeValueFilterPattern = null;
        return this;
    }

    public ZestAssignFromElement first() {
        return this.atIndex(0);
    }

    public ZestAssignFromElement last() {
        return this.atIndex(0, true);
    }

    public ZestAssignFromElement atIndex(int index) {
        return this.atIndex(index, false);
    }

    public ZestAssignFromElement atIndex(int index, boolean reverse) {
        this.reverseFilteredElements = reverse;
        this.elementIndex = index;
        return this;
    }

    private void clearSelectMethod() {
        this.returnElement = false;
        this.returnAttribute = false;
    }

    public ZestAssignFromElement selectContent() {
        this.clearSelectMethod();
        this.returnElement = true;
        return this;
    }

    public ZestAssignFromElement selectAttributeValue(String attributeName) {
        this.clearSelectMethod();
        this.returnAttribute = true;
        this.returnedAttributeName = attributeName;
        return this;
    }

    public boolean isFilteredByElementName() {
        return this.filterElementName;
    }

    public String getElementNameFilter() {
        return this.elementNameFilter;
    }

    public boolean isFilteredByAttribute() {
        return this.filterAttributeValue;
    }

    public String getAttributeNameFilter() {
        return this.attributeNameFilter;
    }

    public String getAttributeValueFilter() {
        return this.attributeValueFilter;
    }

    public int getAttributeValueFilterFlags() {
        return this.attributeValueFilterFlags;
    }

    public boolean areFilteredElementsReversed() {
        return this.reverseFilteredElements;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public boolean isReturningElement() {
        return this.returnElement;
    }

    public boolean isReturningAttribute() {
        return this.returnAttribute;
    }

    public String getReturnedAttributeName() {
        return this.returnedAttributeName;
    }

    public void removeFilter() {
        this.filterElementName = false;
        this.elementNameFilter = null;
        this.filterAttributeValue = false;
        this.attributeNameFilter = null;
        this.attributeValueFilter = null;
        this.attributeValueFilterFlags = 0;
        this.attributeValueFilterPattern = null;
    }

    @Override
    public ZestStatement deepCopy() {
        ZestAssignFromElement zestAssignFromElement = new ZestAssignFromElement(this.getVariableName());
        zestAssignFromElement.filterElementName = this.filterElementName;
        zestAssignFromElement.elementNameFilter = this.elementNameFilter;
        zestAssignFromElement.filterAttributeValue = this.filterAttributeValue;
        zestAssignFromElement.attributeNameFilter = this.attributeNameFilter;
        zestAssignFromElement.attributeValueFilter = this.attributeValueFilter;
        zestAssignFromElement.attributeValueFilterFlags = this.attributeValueFilterFlags;
        zestAssignFromElement.attributeValueFilterPattern = this.attributeValueFilterPattern;
        zestAssignFromElement.reverseFilteredElements = this.reverseFilteredElements;
        zestAssignFromElement.elementIndex = this.elementIndex;
        zestAssignFromElement.returnElement = this.returnElement;
        zestAssignFromElement.returnAttribute = this.returnAttribute;
        zestAssignFromElement.returnedAttributeName = this.returnedAttributeName;
        return zestAssignFromElement;
    }
}

