/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.util.regex.Pattern;
import org.mozilla.zest.core.v1.ZestAssignFailException;
import org.mozilla.zest.core.v1.ZestAssignment;
import org.mozilla.zest.core.v1.ZestResponse;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestAssignReplace
extends ZestAssignment {
    private String replace = null;
    private String replacement = null;
    private boolean regex = false;
    private boolean caseExact = false;

    public ZestAssignReplace() {
    }

    public ZestAssignReplace(String variableName) {
        super(variableName);
    }

    public ZestAssignReplace(String variableName, String replace, String replacement, boolean regex, boolean caseExact) {
        super(variableName);
        this.replace = replace;
        this.replacement = replacement;
        this.regex = regex;
        this.caseExact = caseExact;
    }

    @Override
    public String assign(ZestResponse response, ZestRuntime runtime) throws ZestAssignFailException {
        String var = runtime.getVariable(this.getVariableName());
        if (var == null) {
            return null;
        }
        String orig = runtime.replaceVariablesInString(var, false);
        try {
            return this.createPattern().matcher(orig).replaceAll(this.replacement);
        }
        catch (Exception e) {
            throw new ZestAssignFailException(this, e.getMessage());
        }
    }

    private Pattern createPattern() {
        return Pattern.compile(this.regex ? this.replace : Pattern.quote(this.replace), this.caseExact ? 0 : 2);
    }

    @Override
    public ZestAssignReplace deepCopy() {
        ZestAssignReplace copy = new ZestAssignReplace(this.getVariableName(), this.replace, this.replacement, this.regex, this.caseExact);
        copy.setEnabled(this.isEnabled());
        return copy;
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public void setCaseExact(boolean caseExact) {
        this.caseExact = caseExact;
    }
}

