/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestClient;
import org.mozilla.zest.core.v1.ZestClientFailException;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestRuntime;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class ZestClientElement
extends ZestClient {
    private String windowHandle = null;
    private String type = null;
    private String element = null;

    public ZestClientElement(String windowHandle, String type, String element) {
        this.windowHandle = windowHandle;
        this.type = type;
        this.element = element;
    }

    public ZestClientElement() {
    }

    public String getWindowHandle() {
        return this.windowHandle;
    }

    public void setWindowHandle(String windowHandle) {
        this.windowHandle = windowHandle;
    }

    public String getElement() {
        return this.element;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setElement(String element) {
        this.element = element;
    }

    protected WebElement getWebElement(ZestRuntime runtime) throws ZestClientFailException {
        WebDriver wd = runtime.getWebDriver(this.getWindowHandle());
        if (wd == null) {
            throw new ZestClientFailException((ZestElement)this, "No client: " + runtime.getVariable(this.getWindowHandle()));
        }
        String elem = runtime.replaceVariablesInString(this.getElement(), false);
        try {
            if ("className".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.className((String)elem));
            }
            if ("cssSelector".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.cssSelector((String)elem));
            }
            if ("id".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.id((String)elem));
            }
            if ("linkText".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.linkText((String)elem));
            }
            if ("name".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.name((String)elem));
            }
            if ("partialLinkText".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.partialLinkText((String)elem));
            }
            if ("tagName".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.tagName((String)elem));
            }
            if ("xpath".equalsIgnoreCase(this.type)) {
                return wd.findElement(By.xpath((String)elem));
            }
            throw new ZestClientFailException((ZestElement)this, "Unsupported type: " + this.type);
        }
        catch (Exception e) {
            throw new ZestClientFailException((ZestElement)this, (Throwable)e);
        }
    }
}

