/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import org.mozilla.zest.core.v1.ZestExpression;
import org.mozilla.zest.core.v1.ZestRuntime;

public class ZestExpressionLength
extends ZestExpression {
    private int length;
    private int approx;
    private String variableName;

    public ZestExpressionLength() {
        this(null, 0, 0);
    }

    public ZestExpressionLength(String variableName, int length, int approx) {
        this(variableName, length, approx, false);
    }

    public ZestExpressionLength(String variableName, int length, int approx, boolean inverse) {
        super(inverse);
        this.variableName = variableName;
        this.length = length;
        this.approx = approx;
    }

    @Override
    public ZestExpressionLength deepCopy() {
        return new ZestExpressionLength(this.variableName, this.length, this.approx, this.isInverse());
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getApprox() {
        return this.approx;
    }

    public void setApprox(int approx) {
        this.approx = approx;
    }

    @Override
    public boolean isTrue(ZestRuntime runtime) {
        if (this.variableName == null) {
            return false;
        }
        String value = runtime.getVariable(this.variableName);
        if (value == null) {
            return false;
        }
        boolean toReturn = Math.abs(this.length - value.length()) <= this.length * this.approx / 100;
        return toReturn;
    }

    public String toString() {
        String expression = (this.isInverse() ? "NOT " : "") + "Length: " + this.length + " +/- " + (double)(this.length * this.approx) / 100.0;
        return expression;
    }
}

