/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import org.mozilla.zest.core.v1.ZestLoop;
import org.mozilla.zest.core.v1.ZestLoopStateFile;
import org.mozilla.zest.core.v1.ZestLoopTokenFileSet;
import org.mozilla.zest.core.v1.ZestLoopTokenSet;
import org.mozilla.zest.core.v1.ZestStatement;

public class ZestLoopFile
extends ZestLoop<String> {
    private ZestLoopTokenFileSet set = null;

    public ZestLoopFile() throws IOException {
        this(File.createTempFile("emptyfile", ".txt"));
    }

    private ZestLoopFile(int index) throws IOException {
        super(index);
        this.set = new ZestLoopTokenFileSet(File.createTempFile("emptyfile", ".txt").getAbsolutePath());
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    private ZestLoopFile(File file) throws FileNotFoundException {
        this.set = new ZestLoopTokenFileSet(file.getAbsolutePath());
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    public ZestLoopFile(String pathToFile) throws FileNotFoundException {
        this.set = new ZestLoopTokenFileSet(pathToFile);
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    public ZestLoopFile(int index, String pathToFile) throws FileNotFoundException {
        super(index);
        this.set = new ZestLoopTokenFileSet(pathToFile);
        super.init(this.set, new LinkedList<ZestStatement>());
    }

    @Override
    public ZestLoopFile deepCopy() {
        try {
            ZestLoopFile copy = new ZestLoopFile(this.getIndex());
            copy.setVariableName(this.getVariableName());
            copy.setCurrentState(this.getCurrentState().deepCopy());
            copy.setStatements(this.copyStatements());
            copy.setSet(this.getSet().deepCopy());
            copy.setEnabled(this.isEnabled());
            return copy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getFile() {
        return this.getSet().getFile();
    }

    public ZestLoopStateFile getCurrentState() {
        return (ZestLoopStateFile)super.getCurrentState();
    }

    public ZestLoopTokenFileSet getSet() {
        return this.set;
    }

    @Override
    public void setSet(ZestLoopTokenSet<String> set) {
        if (set instanceof ZestLoopTokenFileSet) {
            try {
                ZestLoopTokenFileSet fileSet = (ZestLoopTokenFileSet)set;
                this.set = new ZestLoopTokenFileSet(fileSet.getFile().getAbsolutePath());
                super.init(set, this.getStatements());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Invelid set. It must be instance of " + ZestLoopTokenFileSet.class.getName());
        }
    }

    @Override
    public boolean isLastState() {
        return super.getCurrentState().isLastState(this.getSet());
    }

    @Override
    public void increase() {
        super.getCurrentState().increase(this.getSet());
    }

    @Override
    public void toLastState() {
        this.getCurrentState().toLastState(this.getSet());
    }

    @Override
    public String getCurrentToken() {
        if (super.getCurrentToken() == null) {
            super.init(this.getSet(), this.getStatements());
        }
        return (String)super.getCurrentToken();
    }

    public boolean loop() {
        return super.loop(this.getSet());
    }

    public void endLoop() {
        super.endLoop(this.getSet());
    }
}

