/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.core.v1;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mozilla.zest.core.v1.ZestAssertion;
import org.mozilla.zest.core.v1.ZestCookie;
import org.mozilla.zest.core.v1.ZestElement;
import org.mozilla.zest.core.v1.ZestResponse;
import org.mozilla.zest.core.v1.ZestStatement;
import org.mozilla.zest.core.v1.ZestVariables;

public class ZestRequest
extends ZestStatement {
    private URL url;
    private String urlToken;
    private String data;
    private String method;
    private String headers;
    private ZestResponse response;
    private List<ZestAssertion> assertions = new ArrayList<ZestAssertion>();
    private boolean followRedirects = true;
    private long timestamp;
    private List<ZestCookie> cookies = new ArrayList<ZestCookie>();

    public ZestRequest(int index) {
        super(index);
    }

    public ZestRequest() {
    }

    @Override
    public ZestRequest deepCopy() {
        ZestRequest zr = new ZestRequest(this.getIndex());
        zr.setUrl(this.url);
        zr.setUrlToken(this.urlToken);
        zr.setData(this.data);
        zr.setMethod(this.method);
        zr.setHeaders(this.headers);
        zr.setFollowRedirects(this.followRedirects);
        zr.setTimestamp(this.timestamp);
        if (this.getResponse() != null) {
            zr.setResponse(this.getResponse().deepCopy());
        }
        for (ZestAssertion zt : this.getAssertions()) {
            zr.addAssertion((ZestAssertion)zt.deepCopy());
        }
        for (ZestCookie cookie : this.cookies) {
            zr.addCookie(new ZestCookie(cookie.getDomain(), cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiryDate(), cookie.isSecure()));
        }
        zr.setEnabled(this.isEnabled());
        return zr;
    }

    public URL getUrl() {
        if (this.url == null && this.urlToken != null) {
            try {
                return new URL(this.urlToken);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getUrlToken() {
        return this.urlToken;
    }

    public void setUrlToken(String urlToken) {
        this.urlToken = urlToken;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void addAssertion(ZestAssertion assertion) {
        this.assertions.add(assertion);
    }

    public void removeAssertion(ZestAssertion assertion) {
        this.assertions.remove(assertion);
    }

    public List<ZestAssertion> getAssertions() {
        return this.assertions;
    }

    public ZestResponse getResponse() {
        return this.response;
    }

    public void setResponse(ZestResponse response) {
        this.response = response;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void moveUp(ZestElement ze) {
        if (ze instanceof ZestAssertion) {
            ZestAssertion za = (ZestAssertion)ze;
            int i = this.assertions.indexOf(za);
            if (i > 0) {
                this.assertions.remove(za);
                this.assertions.add(i - 1, za);
            }
        } else {
            throw new IllegalArgumentException("Unrecognised element class: " + ze.getClass().getCanonicalName());
        }
    }

    public void moveDown(ZestElement ze) {
        if (ze instanceof ZestAssertion) {
            ZestAssertion za = (ZestAssertion)ze;
            int i = this.assertions.indexOf(za);
            if (i >= 0 && i < this.assertions.size()) {
                this.assertions.remove(za);
                this.assertions.add(i + 1, za);
            }
        } else {
            throw new IllegalArgumentException("Unrecognised element class: " + ze.getClass().getCanonicalName());
        }
    }

    public void replaceTokens(ZestVariables tokens) {
        if (this.urlToken != null) {
            this.setUrlToken(tokens.replaceInString(this.urlToken, true));
            try {
                this.setUrl(new URL(this.getUrlToken()));
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (this.url != null) {
            try {
                this.setUrl(new URL(tokens.replaceInString(this.url.toString(), true)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.setMethod(tokens.replaceInString(this.getMethod(), false));
        this.setHeaders(tokens.replaceInString(this.getHeaders(), false));
        this.setData(tokens.replaceInString(this.getData(), false));
        for (ZestCookie cookie : this.cookies) {
            cookie.setDomain(tokens.replaceInString(cookie.getDomain(), false));
            cookie.setName(tokens.replaceInString(cookie.getName(), false));
            cookie.setValue(tokens.replaceInString(cookie.getValue(), false));
            cookie.setPath(tokens.replaceInString(cookie.getPath(), false));
        }
    }

    @Override
    public boolean isSameSubclass(ZestElement ze) {
        return ze instanceof ZestRequest;
    }

    @Override
    public void setPrefix(String oldPrefix, String newPrefix) throws MalformedURLException {
        if (this.getUrl() == null || !this.getUrl().toString().startsWith(oldPrefix)) {
            throw new IllegalArgumentException("Request url " + this.getUrl() + " does not start with " + oldPrefix);
        }
        String urlStr = newPrefix + this.getUrl().toString().substring(oldPrefix.length());
        this.setUrl(new URL(urlStr));
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    public void clearCookies() {
        this.cookies.clear();
    }

    public void addCookie(String domain, String name, String value, String path, Date expiry, boolean secure) {
        this.addCookie(new ZestCookie(domain, name, value, path, expiry, secure));
    }

    public void addCookie(ZestCookie cookie) {
        this.cookies.add(cookie);
    }

    public List<ZestCookie> getCookies() {
        return this.cookies;
    }
}

