/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.zest.impl;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.mozilla.zest.core.v1.ZestRunner;
import org.mozilla.zest.impl.ZestScriptEngineFactory;

public class ZestScriptEngine
extends AbstractScriptEngine {
    private ZestScriptEngineFactory factory;
    private ZestRunner runner;

    public ZestScriptEngine(ZestScriptEngineFactory factory, ZestRunner runner) {
        this.factory = factory;
        this.runner = runner;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (context != null) {
            this.runner.setOutputWriter(context.getWriter());
            Bindings bindings = context.getBindings(100);
            if (bindings != null) {
                for (Map.Entry entry : bindings.entrySet()) {
                    params.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        try {
            return this.runner.runScript(script, params);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (context != null) {
            this.runner.setOutputWriter(context.getWriter());
            Bindings bindings = context.getBindings(100);
            if (bindings != null) {
                for (Map.Entry entry : bindings.entrySet()) {
                    params.put((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        try {
            return this.runner.runScript(reader, params);
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }
}

