/*
 * Decompiled with CFR 0.152.
 */
package org.msyu.javautil.exceptions;

import java.util.Objects;
import org.msyu.javautil.exceptions.ConsumerWithException;
import org.msyu.javautil.exceptions.FunctionWithException;

public final class CloseableChain<I, C extends Exception> {
    private final I output;
    private final ConsumerWithException<? super I, ? extends C> destructor;
    private final CloseableChain<?, ? extends C> prev;

    public static <C extends Exception> CloseableChain<Void, C> newCloseableChain() {
        return new CloseableChain<Object, C>(null, null, null);
    }

    private CloseableChain(I output, ConsumerWithException<? super I, ? extends C> destructor, CloseableChain<?, ? extends C> prev) {
        this.output = output;
        this.destructor = destructor;
        this.prev = prev;
    }

    public final <O, X extends Exception> CloseableChain<O, C> chain(FunctionWithException<? super I, O, X> constructor, ConsumerWithException<? super O, ? extends C> destructor) throws X {
        O newOutput;
        try {
            newOutput = constructor.apply(this.output);
        }
        catch (Throwable x) {
            CloseableChain.close(this, x);
            throw x;
        }
        return new CloseableChain<O, C>(newOutput, destructor, this);
    }

    public final <X extends Exception> CloseableChain<I, C> chainEffects(ConsumerWithException<? super I, X> constructor, ConsumerWithException<? super I, ? extends C> destructor) throws X {
        try {
            constructor.accept(this.output);
        }
        catch (Throwable x) {
            CloseableChain.close(this, x);
            throw x;
        }
        return new CloseableChain<I, C>(this.output, destructor, this);
    }

    public final I getOutput() {
        return this.output;
    }

    private void closeThis() throws C {
        this.destructor.accept(this.output);
    }

    public static void close(CloseableChain<?, ?> chain, Throwable suppressor) {
        Objects.requireNonNull(suppressor, "suppressor is null");
        while (chain != null) {
            if (chain.output != null && chain.destructor != null) {
                try {
                    super.closeThis();
                }
                catch (Throwable t) {
                    suppressor.addSuppressed(t);
                }
            }
            chain = chain.prev;
        }
    }

    public static <C extends Exception> void close(CloseableChain<?, C> chain) throws C {
        Throwable throwable = null;
        CloseableChain<?, Object> link = chain;
        while (link != null) {
            if (link.output != null && link.destructor != null) {
                try {
                    super.closeThis();
                }
                catch (Throwable t) {
                    if (throwable == null) {
                        throwable = t;
                    }
                    throwable.addSuppressed(t);
                }
            }
            link = link.prev;
        }
        if (throwable != null) {
            throw (Exception)throwable;
        }
    }
}

