/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.handler.XmlHandler;
import org.mule.metadata.xml.utils.SchemaHelper;
import org.mule.metadata.xml.utils.XmlConstants;

public class NumberHandler
implements XmlHandler {
    public static final List<QName> NUMBER_TYPES = Arrays.asList(XmlConstants.XSD_BYTE, XmlConstants.XSD_INT, XmlConstants.XSD_INTEGER, XmlConstants.XSD_SHORT, XmlConstants.XSD_NEGATIVEINTEGER, XmlConstants.XSD_NONNEGATIVEINTEGER, XmlConstants.XSD_NONPOSITIVEINTEGER, XmlConstants.XSD_POSITIVEINTEGER, XmlConstants.XSD_UNSIGNEDBYTE, XmlConstants.XSD_UNSIGNEDINT, XmlConstants.XSD_UNSIGNEDSHORT, XmlConstants.XSD_LONG, XmlConstants.XSD_UNSIGNEDLONG, XmlConstants.XSD_FLOAT, XmlConstants.XSD_DOUBLE, XmlConstants.XSD_DECIMAL);

    @Override
    public boolean handles(QName schema) {
        return NUMBER_TYPES.contains(schema);
    }

    @Override
    public TypeBuilder<?> handle(XSSimpleTypeDecl element, Optional<String> defaultValue, BaseTypeBuilder builder) {
        NumberTypeBuilder numberType = builder.numberType();
        if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
            numberType.defaultValue(defaultValue.get());
        }
        Optional<Number> minLength = Optional.ofNullable(element.getFacet(256)).map(SchemaHelper::getDoubleValue);
        Optional<Number> maxLength = Optional.ofNullable(element.getFacet(32)).map(SchemaHelper::getDoubleValue);
        if (minLength.isPresent() || maxLength.isPresent()) {
            numberType.range(minLength.orElse(null), maxLength.orElse(null));
        }
        return numberType;
    }
}

