/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.compiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.Accessor;
import org.mule.mvel2.compiler.ExecutableStatement;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.optimizers.OptimizerFactory;

public class CompiledAccExpression
implements ExecutableStatement,
Serializable {
    private char[] expression;
    private int start;
    private int offset;
    private transient Map<Class, Accessor> accessorsByIngressType;
    private ParserContext context;
    private Class ingressType;

    public CompiledAccExpression(char[] expression, Class ingressType, ParserContext context) {
        this(expression, 0, expression.length, ingressType, context);
    }

    public CompiledAccExpression(char[] expression, int start, int offset, Class ingressType, ParserContext context) {
        this.expression = expression;
        this.start = start;
        this.offset = offset;
        this.accessorsByIngressType = new HashMap<Class, Accessor>(4, 1.0f);
        this.context = context;
        this.ingressType = ingressType != null ? ingressType : Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vrf, Object value) {
        Class<?> valueIngressType = this.ingressType == Object.class && value != null ? value.getClass() : this.ingressType;
        Accessor accessor = this.accessorsByIngressType.get(valueIngressType);
        if (accessor == null) {
            try {
                accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeSetAccessor(this.context, this.expression, 0, this.expression.length, ctx, ctx, vrf, false, value, valueIngressType);
                this.accessorsByIngressType.put(valueIngressType, accessor);
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        } else {
            accessor.setValue(ctx, elCtx, vrf, value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        Accessor accessor = this.accessorsByIngressType.get(this.ingressType);
        if (accessor == null) {
            try {
                accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.context, this.expression, 0, this.expression.length, staticContext, staticContext, factory, false, this.ingressType);
                this.accessorsByIngressType.put(this.ingressType, accessor);
                Object object = this.getValue(staticContext, factory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return accessor.getValue(factory, staticContext, factory);
    }

    public void setKnownIngressType(Class type) {
        this.ingressType = type;
    }

    public void setKnownEgressType(Class type) {
    }

    public Class getKnownIngressType() {
        return this.ingressType;
    }

    public Class getKnownEgressType() {
        return null;
    }

    public boolean isConvertableIngressEgress() {
        return false;
    }

    public void computeTypeConversionRule() {
    }

    public boolean intOptimized() {
        return false;
    }

    public boolean isLiteralOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        Accessor accessor = this.accessorsByIngressType.get(this.ingressType);
        if (accessor == null) {
            try {
                accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.context, this.expression, this.start, this.offset, ctx, elCtx, variableFactory, false, this.ingressType);
                this.accessorsByIngressType.put(this.ingressType, accessor);
                Object object = this.getValue(ctx, elCtx, variableFactory);
                return object;
            }
            finally {
                OptimizerFactory.clearThreadAccessorOptimizer();
            }
        }
        return accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Accessor getAccessor() {
        return this.isEmptyStatement() ? null : this.accessorsByIngressType.values().iterator().next();
    }

    public boolean isEmptyStatement() {
        return this.accessorsByIngressType.isEmpty();
    }

    public boolean isExplicitCast() {
        return false;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.accessorsByIngressType = new HashMap<Class, Accessor>(4, 1.0f);
    }
}

