/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import com.google.common.base.Throwables;
import java.util.List;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.spring.LazyComponentInitializer;
import org.mule.runtime.config.spring.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.core.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.core.api.exception.ObjectNotFoundException;

public class LazyConnectivityTestingService
implements ConnectivityTestingService {
    private final LazyComponentInitializer lazyComponentInitializer;
    private final ConnectivityTestingService connectivityTestingService;

    public LazyConnectivityTestingService(LazyComponentInitializer lazyComponentInitializer, ConnectivityTestingService connectivityTestingService) {
        this.lazyComponentInitializer = lazyComponentInitializer;
        this.connectivityTestingService = connectivityTestingService;
    }

    @Override
    public ConnectionValidationResult testConnection(Location location) {
        try {
            this.lazyComponentInitializer.initializeComponent(location);
        }
        catch (MuleRuntimeException e) {
            if (e.getCause() instanceof NoSuchComponentModelException) {
                throw new ObjectNotFoundException(location.toString());
            }
            List causalChain = Throwables.getCausalChain((Throwable)e);
            return causalChain.stream().filter(exception -> exception.getClass().equals(ConnectionException.class) && ((ConnectionException)exception).getErrorType().isPresent()).map(exception -> ConnectionValidationResult.failure(exception.getMessage(), ((ConnectionException)exception).getErrorType().get(), (Exception)exception)).findFirst().orElse(this.unknownFailureResponse(this.lastMessage(causalChain), e));
        }
        catch (Exception e) {
            return this.unknownFailureResponse(e.getMessage(), e);
        }
        return this.connectivityTestingService.testConnection(location);
    }

    private ConnectionValidationResult unknownFailureResponse(String message, Exception e) {
        return ConnectionValidationResult.failure(message, e);
    }

    private String lastMessage(List<Throwable> causalChain) {
        return causalChain.get(causalChain.size() - 1).getMessage();
    }
}

