/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.context.notification.ClusterNodeNotificationListener;
import org.mule.runtime.core.api.context.notification.ComponentMessageNotificationListener;
import org.mule.runtime.core.api.context.notification.ConnectionNotificationListener;
import org.mule.runtime.core.api.context.notification.ConnectorMessageNotificationListener;
import org.mule.runtime.core.api.context.notification.CustomNotificationListener;
import org.mule.runtime.core.api.context.notification.ErrorHandlerNotificationListener;
import org.mule.runtime.core.api.context.notification.ExceptionNotificationListener;
import org.mule.runtime.core.api.context.notification.ManagementNotificationListener;
import org.mule.runtime.core.api.context.notification.MessageProcessorNotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.RegistryNotificationListener;
import org.mule.runtime.core.api.context.notification.RoutingNotificationListener;
import org.mule.runtime.core.api.context.notification.SecurityNotificationListener;
import org.mule.runtime.core.api.context.notification.TransactionNotificationListener;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.context.notification.AsyncMessageNotification;
import org.mule.runtime.core.context.notification.ComponentMessageNotification;
import org.mule.runtime.core.context.notification.ConnectionNotification;
import org.mule.runtime.core.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.context.notification.CustomNotification;
import org.mule.runtime.core.context.notification.ErrorHandlerNotification;
import org.mule.runtime.core.context.notification.ExceptionNotification;
import org.mule.runtime.core.context.notification.ManagementNotification;
import org.mule.runtime.core.context.notification.MessageProcessorNotification;
import org.mule.runtime.core.context.notification.MuleContextNotification;
import org.mule.runtime.core.context.notification.PipelineMessageNotification;
import org.mule.runtime.core.context.notification.RegistryNotification;
import org.mule.runtime.core.context.notification.RoutingNotification;
import org.mule.runtime.core.context.notification.SecurityNotification;
import org.mule.runtime.core.context.notification.TransactionNotification;

public class NotificationConfig
extends AbstractAnnotatedObject {
    private static final String ENDPOINT_MESSAGE_NOTIFICATION_CLASS = "com.mulesoft.mule.compatibility.core.context.notification.EndpointMessageNotification";
    private static final String ENDPOINT_MESSAGE_NOTIFICATION_LISTENER_CLASS = "com.mulesoft.mule.compatibility.core.api.context.notification.EndpointMessageNotificationListener";
    private static final Map<String, String> EVENT_MAP = new HashMap<String, String>();
    private static final Map<String, String> INTERFACE_MAP;
    private String eventName;
    private Class eventClass;
    private String interfaseName;
    private Class interfaceClass;
    private boolean eventExplicitlyConfigured;
    private boolean interfaceExplicitlyConfigured;

    public NotificationConfig(Class interfaceClass, Class eventClass) {
        this.interfaceClass = interfaceClass;
        this.eventClass = eventClass;
    }

    public NotificationConfig() {
    }

    public void setInterfaseName(String interfaseName) {
        this.interfaceExplicitlyConfigured = true;
        this.interfaseName = interfaseName;
    }

    public void setEventClass(Class eventClass) {
        this.eventExplicitlyConfigured = true;
        this.eventClass = eventClass;
    }

    public void setEventName(String eventName) {
        this.eventExplicitlyConfigured = true;
        this.eventName = eventName;
    }

    public void setInterfaceClass(Class interfaceClass) {
        this.interfaceExplicitlyConfigured = true;
        this.interfaceClass = interfaceClass;
    }

    public Optional<Class> getEventClass() {
        if (this.eventClass != null) {
            return Optional.of(this.eventClass);
        }
        if (this.eventName != null) {
            return Optional.of(this.loadClass(EVENT_MAP.get(this.eventName)));
        }
        return Optional.ofNullable(this.loadClass(EVENT_MAP.get(this.interfaseName)));
    }

    private Class loadClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            return ClassUtils.loadClass(className, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public Optional<Class> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return Optional.of(this.interfaceClass);
        }
        if (this.interfaseName != null) {
            return Optional.of(this.loadClass(INTERFACE_MAP.get(this.interfaseName)));
        }
        return Optional.ofNullable(this.loadClass(INTERFACE_MAP.get(this.eventName)));
    }

    public boolean isEventExplicitlyConfigured() {
        return this.eventExplicitlyConfigured;
    }

    public boolean isInterfaceExplicitlyConfigured() {
        return this.interfaceExplicitlyConfigured;
    }

    static {
        EVENT_MAP.put("CONTEXT", MuleContextNotification.class.getName());
        EVENT_MAP.put("SECURITY", SecurityNotification.class.getName());
        EVENT_MAP.put("ENDPOINT-MESSAGE", ENDPOINT_MESSAGE_NOTIFICATION_CLASS);
        EVENT_MAP.put("CONNECTOR-MESSAGE", ConnectorMessageNotification.class.getName());
        EVENT_MAP.put("COMPONENT-MESSAGE", ComponentMessageNotification.class.getName());
        EVENT_MAP.put("MANAGEMENT", ManagementNotification.class.getName());
        EVENT_MAP.put("MESSAGE-PROCESSOR", MessageProcessorNotification.class.getName());
        EVENT_MAP.put("EXCEPTION-STRATEGY", ErrorHandlerNotification.class.getName());
        EVENT_MAP.put("CONNECTION", ConnectionNotification.class.getName());
        EVENT_MAP.put("REGISTRY", RegistryNotification.class.getName());
        EVENT_MAP.put("CUSTOM", CustomNotification.class.getName());
        EVENT_MAP.put("EXCEPTION", ExceptionNotification.class.getName());
        EVENT_MAP.put("TRANSACTION", TransactionNotification.class.getName());
        EVENT_MAP.put("ROUTING", RoutingNotification.class.getName());
        EVENT_MAP.put("PIPELINE-MESSAGE", PipelineMessageNotification.class.getName());
        EVENT_MAP.put("ASYNC-MESSAGE", AsyncMessageNotification.class.getName());
        INTERFACE_MAP = new HashMap<String, String>();
        INTERFACE_MAP.put("CONTEXT", MuleContextNotificationListener.class.getName());
        INTERFACE_MAP.put("SECURITY", SecurityNotificationListener.class.getName());
        INTERFACE_MAP.put("MANAGEMENT", ManagementNotificationListener.class.getName());
        INTERFACE_MAP.put("MESSAGE-PROCESSOR", MessageProcessorNotificationListener.class.getName());
        INTERFACE_MAP.put("EXCEPTION-STRATEGY", ErrorHandlerNotificationListener.class.getName());
        INTERFACE_MAP.put("CONNECTION", ConnectionNotificationListener.class.getName());
        INTERFACE_MAP.put("REGISTRY", RegistryNotificationListener.class.getName());
        INTERFACE_MAP.put("CUSTOM", CustomNotificationListener.class.getName());
        INTERFACE_MAP.put("ENDPOINT-MESSAGE", ENDPOINT_MESSAGE_NOTIFICATION_LISTENER_CLASS);
        INTERFACE_MAP.put("CONNECTOR-MESSAGE", ConnectorMessageNotificationListener.class.getName());
        INTERFACE_MAP.put("COMPONENT-MESSAGE", ComponentMessageNotificationListener.class.getName());
        INTERFACE_MAP.put("EXCEPTION", ExceptionNotificationListener.class.getName());
        INTERFACE_MAP.put("TRANSACTION", TransactionNotificationListener.class.getName());
        INTERFACE_MAP.put("ROUTING", RoutingNotificationListener.class.getName());
        INTERFACE_MAP.put("CLUSTER-NODE", ClusterNodeNotificationListener.class.getName());
        INTERFACE_MAP.put("PIPELINE-MESSAGE", PipelineMessageNotification.class.getName());
        INTERFACE_MAP.put("ASYNC-MESSAGE", AsyncMessageNotification.class.getName());
        EVENT_MAP.put("MESSAGE", ENDPOINT_MESSAGE_NOTIFICATION_CLASS);
    }

    public static class DisabledNotificationConfig
    extends NotificationConfig {
        public DisabledNotificationConfig(Class interfaceClass, Class eventClass) {
            super(interfaceClass, eventClass);
        }

        public DisabledNotificationConfig() {
        }
    }

    public static class EnabledNotificationConfig
    extends NotificationConfig {
        public EnabledNotificationConfig(Class interfaceClass, Class eventClass) {
            super(interfaceClass, eventClass);
        }

        public EnabledNotificationConfig() {
        }
    }
}

