/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import java.util.List;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorChainBuilder;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.springframework.beans.factory.FactoryBean;

public class MessageProcessorChainFactoryBean
extends AbstractAnnotatedObject
implements FactoryBean,
MuleContextAware {
    protected List processors;
    protected String name;
    protected MuleContext muleContext;

    public Class getObjectType() {
        return Processor.class;
    }

    public void setMessageProcessors(List processors) {
        this.processors = processors;
    }

    public Object getObject() throws Exception {
        MessageProcessorChainBuilder builder = this.getBuilderInstance();
        for (Object processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain((Processor)processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)processor);
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        MessageProcessorChain messageProcessorChain = builder.build();
        messageProcessorChain.setMuleContext(this.muleContext);
        messageProcessorChain.setAnnotations(this.getAnnotations());
        return messageProcessorChain;
    }

    protected MessageProcessorChainBuilder getBuilderInstance() {
        ExplicitMessageProcessorChainBuilder builder = new ExplicitMessageProcessorChainBuilder();
        builder.setName("processor chain '" + this.name + "'");
        return builder;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

