/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.generic;

import org.mule.runtime.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.w3c.dom.Element;

public class OrphanDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    private Class<?> beanClass = null;
    private boolean dynamicClass = false;

    public OrphanDefinitionParser(boolean singleton) {
        this.singleton = singleton;
        this.dynamicClass = true;
    }

    public OrphanDefinitionParser(Class<?> beanClass, boolean singleton) {
        this.beanClass = beanClass;
        this.singleton = singleton;
    }

    @Override
    protected void preProcess(Element element) {
        super.preProcess(element);
        AutoIdUtils.ensureUniqueId(element, "bean");
        if (this.dynamicClass) {
            this.beanClass = null;
        }
    }

    @Override
    protected Class<?> getBeanClass(Element element) {
        return this.beanClass;
    }
}

