/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.io.File;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.util.StandaloneServerUtils;

public class MuleFoldersUtil {
    public static final String EXECUTION_FOLDER = ".mule";
    public static final String LIB_FOLDER = "lib";
    public static final String CONFIG_FOLDER = "mule";
    public static final String SHARED_FOLDER = "shared";
    public static final String APPS_FOLDER = "apps";
    public static final String PLUGINS_FOLDER = "plugins";
    public static final String CLASSES_FOLDER = "classes";
    public static final String DOMAINS_FOLDER = "domains";
    public static final String CONTAINER_APP_PLUGINS = "plugins";
    public static final String USER_FOLDER = "user";
    public static final String SERVICES_FOLDER = "services";

    private MuleFoldersUtil() {
    }

    public static File getMuleHomeFolder() {
        File muleHome = StandaloneServerUtils.getMuleHome().orElse(null);
        if (muleHome == null) {
            muleHome = new File(".");
        }
        return muleHome;
    }

    public static File getMuleBaseFolder() {
        File muleBase = StandaloneServerUtils.getMuleBase().orElse(null);
        if (muleBase == null) {
            muleBase = MuleFoldersUtil.getMuleHomeFolder();
        }
        return muleBase;
    }

    public static File getServicesFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), SERVICES_FOLDER);
    }

    public static File getServiceFolder(String name) {
        Preconditions.checkArgument(!StringUtils.isEmpty(name), "name cannot be empty");
        return new File(MuleFoldersUtil.getServicesFolder(), name);
    }

    public static File getDomainsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), DOMAINS_FOLDER);
    }

    public static File getDomainFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainsFolder(), domainName);
    }

    public static File getDomainLibFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainFolder(domainName), LIB_FOLDER);
    }

    public static File getAppsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), APPS_FOLDER);
    }

    public static File getAppFolder(String appName) {
        return new File(MuleFoldersUtil.getAppsFolder(), appName);
    }

    public static File getAppTempFolder(String appName) {
        return new File(new File(MuleFoldersUtil.getExecutionFolder(), appName), "temp");
    }

    public static File getAppClassesFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), CLASSES_FOLDER);
    }

    public static File getAppLibFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppLibsFolderPath());
    }

    public static File getAppPluginsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppPluginsFolderPath());
    }

    public static String getAppPluginsFolderPath() {
        return "plugins" + File.separator;
    }

    public static File getAppSharedLibsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppSharedLibsFolderPath());
    }

    public static String getAppSharedLibsFolderPath() {
        return MuleFoldersUtil.getAppLibsFolderPath() + SHARED_FOLDER + File.separator;
    }

    private static String getAppLibsFolderPath() {
        return LIB_FOLDER + File.separator;
    }

    public static File getAppConfigFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppConfigFolderPath());
    }

    public static String getAppConfigFolderPath() {
        return CONFIG_FOLDER + File.separator;
    }

    public static File getExecutionFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), EXECUTION_FOLDER);
    }

    public static File getMuleLibFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), LIB_FOLDER);
    }

    public static File getUserLibFolder() {
        return new File(MuleFoldersUtil.getMuleLibFolder(), USER_FOLDER);
    }

    public static File getContainerAppPluginsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), "plugins");
    }

    public static File getServicesTempFolder() {
        return new File(MuleFoldersUtil.getExecutionFolder(), SERVICES_FOLDER);
    }
}

