/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.model.streaming;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackOutputStream
extends OutputStream {
    private static final Logger logger = LoggerFactory.getLogger(CallbackOutputStream.class);
    private OutputStream delegate;
    private Callback callback;

    public CallbackOutputStream(OutputStream delegate, Callback callback) {
        this.delegate = delegate;
        this.callback = callback;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        finally {
            this.closeCallback();
        }
    }

    private void closeCallback() {
        if (null != this.callback) {
            try {
                this.callback.onClose();
            }
            catch (Exception e) {
                logger.debug("Suppressing exception while releasing resources: " + e.getMessage());
            }
        }
    }

    public static interface Callback {
        public void onClose() throws Exception;
    }
}

