/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;

public class AttributeEvaluator {
    private static final Pattern SINGLE_EXPRESSION_REGEX_PATTERN = Pattern.compile("^#\\[(?:(?!#\\[).)*]$", 32);
    private static final BindingContext NULL_BINDING_CONTEXT = BindingContext.builder().build();
    private static final List<Class<?>> BLACK_LIST_TYPES = Arrays.asList(Object.class, InputStream.class, Iterator.class, Serializable.class);
    private String attributeValue;
    private ExtendedExpressionManager expressionManager;
    private Function<Event, TypedValue> expressionResolver;

    public AttributeEvaluator(String attributeValue) {
        this(attributeValue, null);
    }

    public AttributeEvaluator(String attributeValue, DataType expectedDataType) {
        this.attributeValue = this.sanitize(attributeValue);
        switch (this.resolveAttributeType()) {
            case EXPRESSION: {
                if (expectedDataType != null && !BLACK_LIST_TYPES.contains(expectedDataType.getType())) {
                    this.expressionResolver = event -> this.expressionManager.evaluate(this.attributeValue, expectedDataType, NULL_BINDING_CONTEXT, (Event)event);
                    break;
                }
                this.expressionResolver = event -> this.expressionManager.evaluate(this.attributeValue, (Event)event);
                break;
            }
            case PARSE_EXPRESSION: {
                this.expressionResolver = event -> new TypedValue<String>(this.expressionManager.parse(this.attributeValue, (Event)event, null), DataType.STRING);
                break;
            }
            case STATIC_VALUE: {
                this.expressionResolver = event -> new TypedValue<String>(this.attributeValue, this.attributeValue == null ? DataType.OBJECT : DataType.STRING);
            }
        }
    }

    public AttributeEvaluator initialize(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    private String sanitize(String attributeValue) {
        if (attributeValue != null) {
            attributeValue = attributeValue.trim().replaceAll("\r", "").replaceAll("\t", "");
        }
        return attributeValue;
    }

    private AttributeType resolveAttributeType() {
        if (this.attributeValue != null && SINGLE_EXPRESSION_REGEX_PATTERN.matcher(this.attributeValue).matches()) {
            return AttributeType.EXPRESSION;
        }
        if (this.attributeValue != null && this.isParseExpression(this.attributeValue)) {
            return AttributeType.PARSE_EXPRESSION;
        }
        return AttributeType.STATIC_VALUE;
    }

    private boolean isParseExpression(String attributeValue) {
        int beginExpression = attributeValue.indexOf("#[");
        if (beginExpression == -1) {
            return false;
        }
        String remainingString = attributeValue.substring(beginExpression + "#[".length());
        return remainingString.contains("]");
    }

    public <T> TypedValue<T> resolveTypedValue(Event event) {
        return this.expressionResolver.apply(event);
    }

    public <T> T resolveValue(Event event) {
        TypedValue<T> resolveTypedValue = this.resolveTypedValue(event);
        return resolveTypedValue.getValue();
    }

    public String getRawValue() {
        return this.attributeValue;
    }

    private static enum AttributeType {
        EXPRESSION,
        PARSE_EXPRESSION,
        STATIC_VALUE;

    }
}

