/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.SystemUtils;

public class CollectionUtils {
    public static String toString(Collection c, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        return CollectionUtils.toString(c, c.size(), newline);
    }

    public static String toString(Collection c, int maxElements) {
        return CollectionUtils.toString(c, maxElements, false);
    }

    public static String toString(Collection c, int maxElements, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        int origNumElements = c.size();
        int numElements = Math.min(origNumElements, maxElements);
        boolean tooManyElements = origNumElements > maxElements;
        StringBuilder buf = new StringBuilder(numElements * 32);
        buf.append('[');
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        Iterator items = c.iterator();
        for (int i = 0; i < numElements - 1; ++i) {
            Object item = items.next();
            if (item instanceof Class) {
                buf.append(((Class)item).getName());
            } else {
                buf.append(item);
            }
            if (newline) {
                buf.append(SystemUtils.LINE_SEPARATOR);
                continue;
            }
            buf.append(',').append(' ');
        }
        Object lastItem = items.next();
        if (lastItem instanceof Class) {
            buf.append(((Class)lastItem).getName());
        } else {
            buf.append(lastItem);
        }
        if (newline) {
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        if (tooManyElements) {
            buf.append(" [..]");
        }
        buf.append(']');
        return buf.toString();
    }
}

