/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.metadata.SimpleDataType;

public class DefaultCollectionDataType
extends SimpleDataType
implements CollectionDataType {
    private static final long serialVersionUID = 3600944898597616006L;
    private final DataType itemsType;

    DefaultCollectionDataType(Class collectionType, DataType type, MediaType mimeType, boolean streamType) {
        super(collectionType, mimeType, streamType);
        this.itemsType = type;
    }

    @Override
    public DataType getItemDataType() {
        return this.itemsType;
    }

    @Override
    public boolean isCompatibleWith(DataType dataType) {
        if (!(dataType instanceof DefaultCollectionDataType)) {
            return false;
        }
        if (!super.isCompatibleWith(dataType)) {
            return false;
        }
        DefaultCollectionDataType that = (DefaultCollectionDataType)dataType;
        return this.getItemDataType().isCompatibleWith(that.getItemDataType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCollectionDataType that = (DefaultCollectionDataType)o;
        if (!this.getItemDataType().equals(that.getItemDataType())) {
            return false;
        }
        if ((this.mimeType != null ? !this.mimeType.matches(that.mimeType) : that.mimeType != null) && !MediaType.ANY.matches(that.mimeType) && !MediaType.ANY.matches(this.mimeType)) {
            return false;
        }
        return this.getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getItemDataType().hashCode();
        result = 31 * result + (this.getMediaType() != null ? this.getMediaType().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CollectionDataType{type=" + this.getType().getName() + ", itemType=" + this.getItemDataType().toString() + ", mimeType='" + this.getMediaType() + '\'' + '}';
    }
}

