/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.pool;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool.PoolableObjectFactory;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.util.pool.LifecyleEnabledObjectPool;
import org.mule.runtime.core.internal.util.pool.CommonsPoolObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycleEnabledObjectPool
implements LifecyleEnabledObjectPool {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultLifecycleEnabledObjectPool.class);
    private final MuleContext muleContext;
    protected AtomicBoolean started = new AtomicBoolean(false);
    private List items = new LinkedList();
    private final CommonsPoolObjectPool pool;

    public DefaultLifecycleEnabledObjectPool(ObjectFactory objectFactory, PoolingProfile poolingProfile, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.pool = new CommonsPoolObjectPool(objectFactory, poolingProfile, muleContext){

            @Override
            protected PoolableObjectFactory getPooledObjectFactory() {
                return new LifecycleEnabledPoolabeObjectFactoryAdapter();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        this.started.set(true);
        List list = this.items;
        synchronized (list) {
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                ((Startable)i.next()).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        this.started.set(false);
        List list = this.items;
        synchronized (list) {
            Iterator i = this.items.iterator();
            while (i.hasNext()) {
                ((Stoppable)i.next()).stop();
            }
        }
    }

    @Override
    public Object borrowObject() throws Exception {
        return this.pool.borrowObject();
    }

    @Override
    public void returnObject(Object object) {
        this.pool.returnObject(object);
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getMaxActive() {
        return this.pool.getMaxActive();
    }

    @Override
    public void clear() {
        this.pool.clear();
    }

    @Override
    public void close() {
        this.pool.close();
    }

    @Override
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.pool.setObjectFactory(objectFactory);
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.pool.getObjectFactory();
    }

    @Override
    public void dispose() {
        this.pool.dispose();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.pool.initialise();
    }

    class LifecycleEnabledPoolabeObjectFactoryAdapter
    implements PoolableObjectFactory {
        LifecycleEnabledPoolabeObjectFactoryAdapter() {
        }

        public void activateObject(Object obj) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyObject(Object obj) throws Exception {
            if (DefaultLifecycleEnabledObjectPool.this.started.get() && obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if (obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
            List list = DefaultLifecycleEnabledObjectPool.this.items;
            synchronized (list) {
                DefaultLifecycleEnabledObjectPool.this.items.remove(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object makeObject() throws Exception {
            Object object = DefaultLifecycleEnabledObjectPool.this.getObjectFactory().getInstance(DefaultLifecycleEnabledObjectPool.this.muleContext);
            if (DefaultLifecycleEnabledObjectPool.this.started.get() && object instanceof Startable) {
                ((Startable)object).start();
            }
            List list = DefaultLifecycleEnabledObjectPool.this.items;
            synchronized (list) {
                DefaultLifecycleEnabledObjectPool.this.items.add(object);
            }
            return object;
        }

        public void passivateObject(Object obj) throws Exception {
        }

        public boolean validateObject(Object obj) {
            return true;
        }
    }
}

