/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.lifecycle;

import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleState;

public class DefaultLifecycleState
implements LifecycleState {
    private LifecycleManager lifecycleManager;

    DefaultLifecycleState(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    @Override
    public boolean isInitialised() {
        return this.lifecycleManager.isPhaseComplete("initialise");
    }

    @Override
    public boolean isInitialising() {
        return "initialise".equals(this.lifecycleManager.getExecutingPhase());
    }

    @Override
    public boolean isStarted() {
        return "start".equals(this.lifecycleManager.getCurrentPhase());
    }

    @Override
    public boolean isStarting() {
        return "start".equals(this.lifecycleManager.getExecutingPhase());
    }

    @Override
    public boolean isStopped() {
        return "stop".equals(this.lifecycleManager.getCurrentPhase());
    }

    @Override
    public boolean isStopping() {
        return "stop".equals(this.lifecycleManager.getExecutingPhase());
    }

    @Override
    public boolean isDisposed() {
        return this.lifecycleManager.isPhaseComplete("dispose");
    }

    @Override
    public boolean isDisposing() {
        return "dispose".equals(this.lifecycleManager.getExecutingPhase());
    }

    @Override
    public boolean isPhaseComplete(String phase) {
        return this.lifecycleManager.isPhaseComplete(phase);
    }

    @Override
    public boolean isPhaseExecuting(String phase) {
        String executingPhase = this.lifecycleManager.getExecutingPhase();
        if (executingPhase != null) {
            return executingPhase.equals(phase);
        }
        return false;
    }

    @Override
    public boolean isValidTransition(String phase) {
        return this.lifecycleManager.isDirectTransition(phase);
    }
}

