/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.connector.DefaultReplyToHandler;
import org.mule.runtime.core.api.connector.ReplyToHandler;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.util.CopyOnWriteCaseInsensitiveMap;
import org.mule.runtime.core.message.GroupCorrelation;
import org.mule.runtime.core.session.DefaultMuleSession;
import org.mule.runtime.core.util.store.DeserializationPostInitialisable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventBuilder
implements Event.Builder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMessageBuilder.class);
    private EventContext context;
    private Message message;
    private Map<String, TypedValue<Object>> flowVariables = new HashMap<String, TypedValue<Object>>();
    private Map<String, TypedValue<Object>> moduleProperties = new HashMap<String, TypedValue<Object>>();
    private Map<String, TypedValue<Object>> moduleParameters = new HashMap<String, TypedValue<Object>>();
    private Error error;
    private FlowConstruct flow;
    private GroupCorrelation groupCorrelation = new GroupCorrelation(null, null);
    private String legacyCorrelationId;
    private FlowCallStack flowCallStack = new DefaultFlowCallStack();
    private ReplyToHandler replyToHandler;
    private Object replyToDestination;
    private MuleSession session = new DefaultMuleSession();
    private Event originalEvent;
    private boolean modified;
    private boolean notificationsEnabled = true;

    public DefaultEventBuilder(EventContext messageContext) {
        this.context = messageContext;
    }

    public DefaultEventBuilder(Event event) {
        this.context = event.getContext();
        this.originalEvent = event;
        this.message = event.getMessage();
        this.flow = event.getFlowConstruct();
        this.groupCorrelation = event.getGroupCorrelation();
        this.legacyCorrelationId = event.getLegacyCorrelationId();
        this.flowCallStack = event.getFlowCallStack().clone();
        this.replyToHandler = event.getReplyToHandler();
        this.replyToDestination = event.getReplyToDestination();
        this.session = event.getSession();
        this.error = event.getError().orElse(null);
        this.notificationsEnabled = event.isNotificationsEnabled();
        event.getVariableNames().forEach(key -> this.flowVariables.put((String)key, event.getVariable((String)key)));
        this.moduleProperties = event.getProperties();
        this.moduleParameters = event.getParameters();
    }

    public DefaultEventBuilder(EventContext messageContext, Event event) {
        this(event);
        this.context = messageContext;
        this.modified = true;
    }

    @Override
    public Event.Builder message(Message message) {
        Objects.requireNonNull(message);
        this.message = message;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder variables(Map<String, Object> flowVariables) {
        this.copyFromTo(flowVariables, this.flowVariables);
        return this;
    }

    @Override
    public Event.Builder addVariable(String key, Object value) {
        this.flowVariables.put(key, new TypedValue<Object>(value, DataType.fromObject(value)));
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder addVariable(String key, Object value, DataType dataType) {
        this.flowVariables.put(key, new TypedValue<Object>(value, dataType));
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder removeVariable(String key) {
        this.modified = this.flowVariables.remove(key) != null;
        return this;
    }

    @Override
    public Event.Builder properties(Map<String, Object> properties) {
        this.copyFromTo(properties, this.moduleProperties);
        return this;
    }

    @Override
    public Event.Builder parameters(Map<String, Object> parameters) {
        this.copyFromTo(parameters, this.moduleParameters);
        return this;
    }

    @Override
    public Event.Builder removeParameter(String key) {
        this.modified = this.moduleParameters.remove(key) != null;
        return this;
    }

    @Override
    public Event.Builder correlationId(String correlationId) {
        this.legacyCorrelationId = correlationId;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder groupCorrelation(GroupCorrelation correlation) {
        this.groupCorrelation = correlation;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder error(Error error) {
        this.error = error;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder flow(FlowConstruct flow) {
        this.flow = flow;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder replyToHandler(ReplyToHandler replyToHandler) {
        this.replyToHandler = replyToHandler;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder replyToDestination(Object replyToDestination) {
        this.replyToDestination = replyToDestination;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder session(MuleSession session) {
        this.session = session;
        this.modified = true;
        return this;
    }

    @Override
    public Event.Builder disableNotifications() {
        this.notificationsEnabled = false;
        this.modified = true;
        return this;
    }

    @Override
    public Event build() {
        if (this.originalEvent != null && !this.modified) {
            return this.originalEvent;
        }
        Objects.requireNonNull(this.message);
        return new EventImplementation(this.context, this.message, this.flowVariables, this.moduleProperties, this.moduleParameters, this.flow, this.session, this.replyToDestination, this.replyToHandler, this.flowCallStack, this.groupCorrelation, this.error, this.legacyCorrelationId, this.notificationsEnabled);
    }

    private void copyFromTo(Map<String, Object> source, Map<String, TypedValue<Object>> target) {
        target.clear();
        source.forEach((s, o) -> target.put((String)s, new TypedValue<Object>(o, DataType.fromObject(o))));
        this.modified = true;
    }

    public static class EventImplementation
    implements Event,
    DeserializationPostInitialisable {
        private static final long serialVersionUID = 1L;
        private EventContext context;
        private Message message;
        private final MuleSession session;
        private transient FlowConstruct flowConstruct;
        private final ReplyToHandler replyToHandler;
        private final Object replyToDestination;
        private final boolean notificationsEnabled;
        private final CopyOnWriteCaseInsensitiveMap<String, TypedValue> variables = new CopyOnWriteCaseInsensitiveMap();
        private final Map<String, TypedValue<Object>> properties;
        private final Map<String, TypedValue<Object>> parameters;
        private FlowCallStack flowCallStack = new DefaultFlowCallStack();
        private final String legacyCorrelationId;
        private final Error error;
        private String flowName;
        private GroupCorrelation groupCorrelation;

        private EventImplementation(EventContext context, Message message, Map<String, TypedValue<Object>> variables, Map<String, TypedValue<Object>> properties, Map<String, TypedValue<Object>> parameters, FlowConstruct flowConstruct, MuleSession session, Object replyToDestination, ReplyToHandler replyToHandler, FlowCallStack flowCallStack, GroupCorrelation groupCorrelation, Error error, String legacyCorrelationId, boolean notificationsEnabled) {
            this.context = context;
            this.flowConstruct = flowConstruct;
            if (flowConstruct != null) {
                this.flowName = flowConstruct.getName();
            }
            this.session = session;
            this.message = message;
            variables.forEach((s, value) -> this.variables.put((String)s, new TypedValue(value.getValue(), value.getDataType())));
            this.properties = properties;
            this.parameters = parameters;
            this.replyToHandler = replyToHandler;
            this.replyToDestination = replyToDestination;
            this.flowCallStack = flowCallStack;
            this.groupCorrelation = groupCorrelation;
            this.error = error;
            this.legacyCorrelationId = legacyCorrelationId;
            this.notificationsEnabled = notificationsEnabled;
        }

        @Override
        public EventContext getContext() {
            return this.context;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }

        @Override
        public Optional<Error> getError() {
            return Optional.ofNullable(this.error);
        }

        @Override
        public byte[] getMessageAsBytes(MuleContext muleContext) throws DefaultMuleException {
            try {
                return (byte[])this.transformMessage(DataType.BYTE_ARRAY, muleContext);
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsBytes(this.message.getPayload().getValue().getClass().getName()), (Throwable)e);
            }
        }

        @Override
        public <T> T transformMessage(Class<T> outputType, MuleContext muleContext) throws TransformerException {
            return (T)this.transformMessage(DataType.fromType(outputType), muleContext);
        }

        @Override
        public Object transformMessage(DataType outputType, MuleContext muleContext) throws TransformerException {
            if (outputType == null) {
                throw new TransformerException(CoreMessages.objectIsNull("outputType"));
            }
            Message transformedMessage = muleContext.getTransformationService().transform(this.message, outputType);
            if (this.message.getPayload().getDataType().isStreamType()) {
                this.setMessage(transformedMessage);
            }
            return transformedMessage.getPayload().getValue();
        }

        @Override
        public String transformMessageToString(MuleContext muleContext) throws TransformerException {
            DataType dataType = DataType.builder(this.getMessage().getPayload().getDataType()).type(String.class).build();
            return (String)this.transformMessage(dataType, muleContext);
        }

        @Override
        public String getMessageAsString(MuleContext muleContext) throws MuleException {
            return this.getMessageAsString(this.getMessage().getPayload().getDataType().getMediaType().getCharset().orElse(SystemUtils.getDefaultEncoding(muleContext)), muleContext);
        }

        @Override
        public String getMessageAsString(Charset encoding, MuleContext muleContext) throws MuleException {
            try {
                Message transformedMessage = muleContext.getTransformationService().transform(this.message, DataType.builder().type(String.class).charset(encoding).build());
                if (this.message.getPayload().getDataType().isStreamType()) {
                    this.setMessage(transformedMessage);
                }
                return (String)transformedMessage.getPayload().getValue();
            }
            catch (Exception e) {
                throw new DefaultMuleException(CoreMessages.cannotReadPayloadAsString(this.message.getClass().getName()), (Throwable)e);
            }
        }

        public String toString() {
            return "DefaultMuleEvent{context=" + this.context + ", message=" + this.message + ", variables=" + this.variables + ", error=" + this.error + '}';
        }

        @Override
        public MuleSession getSession() {
            return this.session;
        }

        @Override
        public FlowConstruct getFlowConstruct() {
            return this.flowConstruct;
        }

        private void initAfterDeserialisation(MuleContext muleContext) throws MuleException {
            if (this.message instanceof InternalMessage) {
                this.setMessage(this.message);
            }
            if (this.replyToHandler instanceof DefaultReplyToHandler) {
                ((DefaultReplyToHandler)this.replyToHandler).initAfterDeserialisation(muleContext);
            }
            if (this.replyToDestination instanceof DeserializationPostInitialisable) {
                try {
                    DeserializationPostInitialisable.Implementation.init(this.replyToDestination, muleContext);
                }
                catch (Exception e) {
                    throw new DefaultMuleException(e);
                }
            }
            if (this.flowName != null) {
                this.flowConstruct = muleContext.getRegistry().lookupFlowConstruct(this.flowName);
                if (this.flowConstruct instanceof Pipeline) {
                    EventContext cachedValue = ((Pipeline)this.flowConstruct).getSerializationEventContextCache().remove(this.context.getId());
                    this.context = cachedValue != null ? cachedValue : this.context;
                }
            }
        }

        @Override
        public MuleContext getMuleContext() {
            return this.flowConstruct.getMuleContext();
        }

        @Override
        public ReplyToHandler getReplyToHandler() {
            return this.replyToHandler;
        }

        @Override
        public Object getReplyToDestination() {
            return this.replyToDestination;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            if (this.flowName != null && this.flowConstruct instanceof Pipeline) {
                ((Pipeline)this.flowConstruct).getSerializationEventContextCache().put(this.context.getId(), this.context);
            }
            for (Map.Entry<String, TypedValue> entry : this.variables.entrySet()) {
                TypedValue value = entry.getValue();
                if (value == null || value instanceof Serializable) continue;
                String message = String.format("Unable to serialize the flow variable %s, which is of type %s ", entry.getKey(), value);
                logger.error(message);
                throw new IOException(message);
            }
        }

        private void setMessage(Message message) {
            this.message = message;
        }

        @Override
        public Set<String> getVariableNames() {
            return this.variables.keySet();
        }

        @Override
        public <T> TypedValue<T> getVariable(String key) {
            TypedValue typedValue = this.variables.get(key);
            if (typedValue == null) {
                throw new NoSuchElementException("The flow variable '" + key + "' does not exist.");
            }
            return typedValue;
        }

        @Override
        public Map<String, TypedValue<Object>> getProperties() {
            return this.properties;
        }

        @Override
        public Map<String, TypedValue<Object>> getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        @Override
        public SecurityContext getSecurityContext() {
            return this.session.getSecurityContext();
        }

        @Override
        public GroupCorrelation getGroupCorrelation() {
            return this.groupCorrelation;
        }

        @Override
        public String getCorrelationId() {
            return this.legacyCorrelationId != null ? this.legacyCorrelationId : this.getContext().getCorrelationId();
        }

        @Override
        @Deprecated
        public String getLegacyCorrelationId() {
            return this.legacyCorrelationId;
        }
    }
}

