/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.exception.Errors;

public final class ErrorTypeBuilder {
    private String identifier;
    private String namespace;
    private ErrorType parentErrorType;

    public static ErrorTypeBuilder builder() {
        return new ErrorTypeBuilder();
    }

    private ErrorTypeBuilder() {
    }

    public ErrorTypeBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ErrorTypeBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ErrorTypeBuilder parentErrorType(ErrorType parentErrorType) {
        this.parentErrorType = parentErrorType;
        return this;
    }

    public ErrorType build() {
        Preconditions.checkState(this.identifier != null, "string representation cannot be null");
        Preconditions.checkState(this.namespace != null, "namespace representation cannot be null");
        if (!this.isOrphan()) {
            Preconditions.checkState(this.parentErrorType != null, "parent error type cannot be null");
        }
        return new ErrorTypeImplementation(this.identifier, this.namespace, this.parentErrorType);
    }

    private boolean isOrphan() {
        return (this.identifier.equals("ANY") || this.identifier.equals("CRITICAL")) && this.namespace.equals(Errors.CORE_NAMESPACE_NAME);
    }

    private static final class ErrorTypeImplementation
    implements ErrorType {
        private String identifier;
        private String namespace;
        private ErrorType parentErrorType;

        private ErrorTypeImplementation(String identifier, String namespace, ErrorType parentErrorType) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.parentErrorType = parentErrorType;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public ErrorType getParentErrorType() {
            return this.parentErrorType;
        }

        public String toString() {
            return String.format("%s:%s", this.namespace, this.identifier);
        }
    }
}

