/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class TryMessageProcessor
extends AbstractMessageProcessorOwner
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TryMessageProcessor.class);
    protected MessageProcessorChain nestedChain;
    protected MuleTransactionConfig transactionConfig;

    @Override
    public Event process(Event event) throws MuleException {
        if (this.nestedChain == null) {
            return event;
        }
        TransactionalErrorHandlingExecutionTemplate executionTemplate = TransactionalErrorHandlingExecutionTemplate.createScopeExecutionTemplate(this.muleContext, this.flowConstruct, this.transactionConfig, this.messagingExceptionHandler);
        ExecutionCallback<Event> processingCallback = () -> this.nestedChain.process(event);
        try {
            return executionTemplate.execute(processingCallback);
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DefaultMuleException(CoreMessages.errorInvokingMessageProcessorWithinTransaction(this.nestedChain, this.transactionConfig), (Throwable)e);
        }
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.nestedChain == null) {
            return publisher;
        }
        if (TransactionCoordination.isTransactionActive() || this.transactionConfig.getAction() != 6) {
            return Processor.super.apply(publisher);
        }
        return Flux.from(publisher).flatMap(event -> MessageProcessors.processWithChildContext(event, p -> Flux.from((Publisher)p).transform((Function)this.nestedChain)));
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.messagingExceptionHandler = exceptionListener;
    }

    public void setTransactionConfig(MuleTransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    public MuleTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.nestedChain = MessageProcessors.newChain(processors);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = this.muleContext.getDefaultErrorHandler();
        }
        LifecycleUtils.setFlowConstructIfNeeded(this.messagingExceptionHandler, this.flowConstruct);
        LifecycleUtils.initialiseIfNeeded((Object)this.messagingExceptionHandler, true, this.muleContext);
        super.initialise();
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.messagingExceptionHandler, LOGGER);
        super.dispose();
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.messagingExceptionHandler);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.messagingExceptionHandler);
        super.stop();
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    @Override
    public void setMessagingExceptionHandler(MessagingExceptionHandler messagingExceptionHandler) {
    }
}

